<div >
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <style>
        /* Card styles */
        .card {
            border-radius: 12px;
            transition: all 0.3s ease;
        }
        
        .card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.08) !important;
        }
        
        /* Button styles */
        .btn {
            border-radius: 6px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .btn-outline-primary:hover {
            background-color: #0d6efd;
            color: white;
        }
        
        .btn-outline-danger:hover {
            background-color: #dc3545;
            color: white;
        }
        
        /* Badge styles */
        .badge {
            font-weight: 500;
            letter-spacing: 0.3px;
        }
        
        /* Table styles */
        .table {
            font-size: 0.95rem;
        }
        
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0,0,0,0.02);
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(13, 110, 253, 0.05);
        }
        
        /* Form control styles */
        .form-control, .form-select {
            border-radius: 6px;
            padding: 0.6rem 1rem;
            border-color: #dee2e6;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #86b7fe;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        
        /* Form check styles */
        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
        
        /* Custom transaction buttons */
        .transaction-button {
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
            padding: 12px 20px;
            width: 100%;
        }
        
        .transaction-button.active {
            color: white;
            font-weight: 600;
        }
        
        /* Modal styles */
        .modal-content {
            border-radius: 12px;
            overflow: hidden;
        }
        
        .modal-header {
            border-bottom: 0;
            padding: 1.25rem 1.5rem;
        }
        
        .modal-footer {
            border-top: 0;
            padding: 1rem 1.5rem 1.5rem;
        }
        
        /* Animation for arrows */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }
        
        .text-success i, .text-danger i {
            animation: pulse 1.5s infinite;
        }
        
        /* Floating label adjustments */
        .form-floating > .form-control,
        .form-floating > .form-select {
            height: calc(3.5rem + 2px);
            padding: 1rem 0.75rem;
        }
        
        .form-floating > label {
            padding: 1rem 0.75rem;
        }
        
        /* Progress bar for loading states */
        .progress-bar-container {
            height: 4px;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 9999;
        }
        
        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #0d6efd, #dc3545);
            width: 0;
            transition: width 0.3s ease;
        }
        
        /* Loading state for buttons */
        .btn.loading {
            position: relative;
            pointer-events: none;
            opacity: 0.8;
        }
        
        .btn.loading::after {
            content: "";
            position: absolute;
            width: 16px;
            height: 16px;
            top: calc(50% - 8px);
            right: 10px;
            border: 2px solid rgba(255,255,255,0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        /* RTL and Arabic/Kurdish text support */
        [dir="rtl"] {
            text-align: right;
        }
        
        /* Mobile responsiveness adjustments */
        @media (max-width: 768px) {
            .card-body {
                padding: 1rem;
            }
            
            .table {
                font-size: 0.85rem;
            }
            
            .badge.fs-5 {
                font-size: 0.9rem !important;
            }
        }
    </style>
    <!-- Customer Selection Card -->
    <div class="row justify-content-center mb-4">
        <div class="col-6">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white border-bottom-0 pt-4">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="fa fa-users text-primary me-2"></i> {{ __('word.Customer') }}
                    </h5>
                </div>
                <div class="card-body">
                    @livewire('components.custom-select', [
                        'label' => __('word.Customer'),
                        'placeholder' => __('word.Customer'),
                        'identifier' => "filters.customer",
                        'options' =>  $customerOptions,
                    ],
                    key('select-customer'))
                    <small class="text-muted mt-1 d-block">
                        <i class="fa fa-info-circle me-1"></i>
                        ئەم خانەیە پێویستە بۆ دروستکردنی ترەنزەکشن
                    </small>
                    @error('filters.customer') <span class="text-danger small">{{ $message }}</span> @enderror
                    @if(!$filters['customer'])
                        <div class="alert alert-warning mt-2" style="font-size: 12px;">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            <strong>تێبینی:</strong> دەبێت موشتەرێک هەڵبژێردرێت پێش ئەوەی ترەنزەکشنێک دروست بکرێت
                        </div>
                    @endif
                    
                    @if ($filters['customer'])
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <a target="_blank" href="{{ route('show_customer', $selectedCustomer) }}" 
                                class="btn btn-outline-primary w-100 rounded-3 py-2">
                                <i class="fa fa-bank me-2"></i> کشف حساب
                            </a>
                        </div>
                
                    </div>
                    @endif
                </div>
            </div>
        </div>
    
        <div class="col-6">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white border-bottom-0 pt-4">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="fa fa-calendar text-primary me-2"></i> فلتەر
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">لە بەرواری</label>
                            <input type="date" 
                                class="form-control" 
                                wire:model.live="startDate">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">تا بەرواری</label>
                            <input type="date" 
                                class="form-control" 
                                wire:model.live="endDate">
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <button type="button" 
                                    class="btn btn-outline-secondary"
                                    wire:click="resetDateFilter">
                                <i class="fa fa-refresh me-1"></i> سفر کردنەوە بۆ ٣ ڕۆژ
                            </button>
                        </div>
                    </div>
                    <div class="mt-2">
                        <small class="text-muted">
                            <i class="fa fa-info-circle me-1"></i>
                           پیشاندانی داتا لە {{ $startDate }} بۆ {{ $endDate }}
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Transaction Forms Row -->
    <div class="row">
        <!-- USD Section -->
        <div class="col-md-6 mb-4">
            <div class="d-flex justify-content-center mb-3">
                <span class="badge bg-danger fs-5 px-4 py-2 rounded-pill shadow-sm">
                    <i class="fa fa-dollar-sign me-1"></i> حسابی دۆلار
                </span>
                
                @if($this->filters['customer'] && $destinationUSDAccount != null) 
                <a  href="{{ route('accounts.show', ['account' => $destinationUSDAccount, 'openModal' => 1]) }}" 
                    class="badge bg-danger ms-2 fs-5 px-4 py-2 rounded-pill shadow-sm text-decoration-none">
                    <i class="fa fa-exchange me-1"></i> گواستنەوەی پارە
                </a>
                @elseif($this->filters['customer'])
                <span class="badge bg-secondary ms-2 fs-6 px-3 py-2 rounded-pill">
                    موشتەری حسابی بە دۆلار نیە
                </span>
                @endif
            </div>
            
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Transaction type toggle at the top -->
                        <div class="col-12">
                            <div class="form-check mb-3">
                                <input type="checkbox" id="withoutCustomer" wire:model.live="withoutCustomer" 
                                    class="form-check-input">
                                <label for="withoutCustomer" class="form-check-label">
                                    {{ __('word.TransferWithoutAccount') }}
                                </label>
                            </div>
                            
                            <!-- Added Money Transfer checkbox -->
                            <div class="form-check mb-3">
                                <input type="checkbox" id="moneyTransferOnly" wire:model.live="moneyTransferOnly" 
                                    class="form-check-input">
                                <label for="moneyTransferOnly" class="form-check-label">
                                    صرف حوالە
                                </label>
                            </div>
                        </div>
                        
                        <!-- Show these fields when customer without account is selected -->
                        @if($withoutCustomer || $moneyTransferOnly)
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="sender_name" class="form-control" 
                                    wire:model.live="sender_name" placeholder="{{ __('word.SenderName') }}">
                                <label for="sender_name">{{ __('word.SenderName') }}</label>
                                @error('sender_name') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="sender_phone" class="form-control" 
                                    wire:model="sender_phone" placeholder="{{ __('word.PhoneNumber') }}">
                                <label for="sender_phone">{{ __('word.PhoneNumber') }}</label>
                                @error('sender_phone') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        @else
                        <!-- Customer search for USD account when regular customer is selected -->
                        <div class="col-md-6">
                            <div class="position-relative" x-data="{ open: false }">
                                <div class="form-floating mb-3">
                                    <input type="text" id="customer_search" class="form-control" 
                                        wire:model.live="searchCustomer"
                                        placeholder="{{ __('word.SearchByNameOrPhone') }}"
                                        @focus="open = true; $wire.loadCustomers()"
                                        @click.away="setTimeout(() => open = false, 200)">
                                    <label for="customer_search">{{ __('word.SearchCustomer') }}</label>
                                    @error('selectedCustomerId') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>
                                
                                <!-- Hidden input to store the selected customer ID -->
                                <input type="hidden" wire:model="selectedCustomerId">
                                
                                <div class="position-absolute w-100 mt-1 bg-white border rounded shadow" 
                                x-show="open" 
                                     x-show="open"  style="max-height: 250px; overflow-y: auto; z-index: 1000;">
                                    <div  class="p-2 text-muted" x-show="!$wire.customers.length">
                                        <i class="fas fa-info-circle me-1"></i> {{ __('word.NoResultsFound') }}
                                    </div>
                                    @foreach($customers as $customer)
                                        @if($customer['customer_name'] !== 'Cashiers' && $customer['customer_name'] !== 'Bank (Cashboxes)')
                                        <a href="#" class="list-group-item list-group-item-action p-1 transition-all" 
                                            wire:key="customer-{{ $customer['id'] }}"
                                            wire:click.prevent="selectCustomer({{ $customer['id'] }}); open = false;">
                                            ({{ $customer['id'] }}) - {{ $customer['customer_name'] }} - {{ $customer['phone_number'] }}
                                        </a>
                                        <hr>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="sender_phone" class="form-control" 
                                    wire:model="sender_phone" readonly placeholder="{{ __('word.PhoneNumber') }}">
                                <label for="sender_phone">{{ __('word.PhoneNumber') }}</label>
                            </div>
                        </div>
                        @endif
                
                        <!-- Receiver information (for both modes) -->
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="receiver_name" class="form-control" 
                                    wire:model="receiver_name" placeholder="{{ __('word.ReceiverName') }}">
                                <label for="receiver_name">{{ __('word.ReceiverName') }}</label>
                                @error('receiver_name') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="receiver_phone" class="form-control" 
                                    wire:model="receiver_phone" placeholder="{{ __('word.PhoneNumber') }}">
                                <label for="receiver_phone">{{ __('word.PhoneNumber') }}</label>
                                @error('receiver_phone') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" 
                                    wire:model="create_transaction_amount" class="form-control" 
                                    id="transaction_amount" placeholder="{{ __('word.Amount') }}">
                                <label for="transaction_amount">{{ __('word.TransactionAmount') }}</label>
                                @error('create_transaction_amount') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <select wire:model="create_transaction_type" class="form-select" id="transaction_type">
                                    @foreach($transactionTypes as $type)
                                        <option value="{{ $type }}">
                                            @if($type == 'deposit')
                                            {{ __('word.Deposit') }}
                                            @elseif($type == 'withdrawal')
                                            {{ __('word.Withdrawal') }}
                                            @elseif($type == 'transfer')
                                            {{ __('word.Transfer') }}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                <label for="transaction_type">{{ __('word.TransactionType') }}</label>
                                @error('create_transaction_type') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                
                       
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" 
                                    wire:model="create_transaction_fee" class="form-control" 
                                    id="transaction_fee" placeholder="{{ __('word.Fee') }}">
                                <label for="transaction_fee">
                                     @if($withoutCustomer)
                                         عمولەی {{ $this->sender_name}}
                                        @else
                                           {{ __('word.SenderFee') }}
                                        @endif 
                                </label>
                                @error('create_transaction_fee') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
            
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" id="create_get_fee" 
                                    class="form-control" wire:model="create_get_fee" placeholder="{{ __('word.MyFee') }}">
                                    <label for="create_get_fee">                  
                                        @if($withoutCustomer)
                                            {{ __('word.CustomerFee', ['name' => $selectedCustomerName ?? 'الامان']) }}
                                        @else
                                            @if(isset($this->filters['customer']))
                                            {{ __('word.CustomerFee', ['name' => $selectedCustomerName ?? 'الامان']) }}
                                            @else
                                                {{ __('word.CustomerFee', ['name' => 'الامان']) }}
                                            @endif
                                        @endif 
                                    </label>
                                @error('create_get_fee') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                
                
                        <div class="col-md-6">
                            <label for="file" class="form-label">{{ __('word.File') }}</label>
                            <input type="file" class="form-control" wire:model="file" id="file" accept="image/*">
                            @error('file') <span class="text-danger small">{{ $message }}</span> @enderror
                        </div>
                
                        <div class="col-12">
                            <div class="form-floating mb-3">
                                <textarea wire:model="create_note" class="form-control" id="note" 
                                    placeholder="{{ __('word.Note') }}" style="height: 100px"></textarea>
                                <label for="note">{{ __('word.Note') }}</label>
                                @error('create_note') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-white border-top-0 pb-3">
                    <button wire:click="saveCreateUSD" type="submit" class="btn btn-danger px-4 py-2">
                        <i class="fa fa-save me-2"></i> {{ __('word.Save') }}
                    </button>
                </div>
            </div>

            <!-- USD Transactions Table -->
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white border-bottom-0 d-flex justify-content-between align-items-center pt-3">
                    <h5 class="card-title fw-bold text-danger mb-0">
                        <i class="fa fa-history me-2"></i> حەرەکەکانی دۆلار
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>@lang('word.TransactionType')</th>
                                    <th>@lang('word.TransactionAmount')</th>
                                    <th>@lang('word.Fee')</th>
                                    <th>@lang('word.Balance')</th>
                                    <th>@lang('word.Date')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $customer_balance = 0;
                                    $currency_name = '';
                                @endphp
                                @if ($USDAccount)
                                @php
                                    $previous_balance = 0;
                                @endphp
                                    @forelse ($USDAccount->pendingTransactions
                                        // ->filter(fn($transaction) => $transaction->status === 'approved')
                                        ->filter(fn($transaction) => $transaction->transaction_type !== 'fee')
                                        as $transaction)
                                    @php
                                        $currency_name = $transaction->account->currency->currency_name;
                                        $previous_balance = $customer_balance;
                                        $transaction_amount = $transaction->transaction_amount;
                                        $transaction_fee = $transaction->fees->sum('fee_amount') ?? 0;
                                        
                                        if ($transaction->transaction_type == 'deposit') {
                                            $net_amount = $transaction_amount - $transaction_fee;
                                            $customer_balance += $net_amount;
                                        } elseif (in_array($transaction->transaction_type, ['transfer', 'withdrawal'])) {
                                            $total_deduction = $transaction_amount + $transaction_fee;
                                            $customer_balance -= $total_deduction;
                                        }
                                        
                                        $balance_change = $customer_balance - $previous_balance;
                                    @endphp
                                    <tr>
                                        <td>
                                            @if($transaction->transaction_type == 'deposit')
                                            <span class="badge bg-success rounded-pill">{{ __('word.Deposit') }}</span>
                                            @elseif($transaction->transaction_type == 'withdrawal')
                                            <span class="badge bg-danger rounded-pill">{{ __('word.Withdrawal') }}</span>
                                            @elseif($transaction->transaction_type == 'transfer')
                                            <span class="badge bg-primary rounded-pill">{{ __('word.Transfer') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ number_format($transaction->transaction_amount, 0, '.', ',') }}</td>
                                        <td>{{$transaction->get_fee}}</td>
                                        <td>
                                            {{ number_format($customer_balance, 0, '.', ',') }} 
                                            @if ($balance_change > 0)
                                                <span class="text-success ms-1"><i class="fa fa-arrow-up"></i></span>
                                            @elseif ($balance_change < 0)
                                                <span class="text-danger ms-1"><i class="fa fa-arrow-down"></i></span>
                                            @endif
                                        </td>
                                        <td>{{ $transaction->transaction_time }} - {{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                        <td>
                                            <a target="_blank" href="{{ route('invoice-transfer', [$transaction->id]) }}" class="btn btn-sm btn-outline-dark">
                                                <i class="fa fa-print"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-3">@lang('word.Empty')</td>
                                    </tr>
                                    @endforelse
                                @else
                                <tr>
                                    <td colspan="6" class="text-center py-3">@lang('word.NoAccountSelected')</td>
                                </tr>
                                @endif
                            </tbody>
                            <tfoot class="table-light fw-bold">
                                <tr>
                                    <td colspan="3" class="text-end">{{ __('کۆی گشتی') }}</td>
                                    <td>{{ number_format($customer_balance, 0, '.', ',') }} {{ $currency_name }}</td>
                                    <td colspan="2"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- IQD Section -->
        <div class="col-md-6 mb-4">
            <div class="d-flex justify-content-center mb-3">
                <span class="badge bg-success fs-5 px-4 py-2 rounded-pill shadow-sm">
                    <i class="fa fa-money-bill me-1"></i> حسابی دینار
                </span>
                
                @if($this->filters['customer'] && $destinationIQDAccount != null) 
                <a href="{{ route('accounts.show', ['account' => $destinationIQDAccount, 'openModal' => 1]) }}" 
                    class="badge bg-success ms-2 fs-5 px-4 py-2 rounded-pill shadow-sm text-decoration-none">
                    <i class="fa fa-exchange me-1"></i> گواستنەوەی پارە
                </a>
                @elseif($this->filters['customer'])
                <span class="badge bg-secondary ms-2 fs-6 px-3 py-2 rounded-pill">
                    موشتەری حسابی بە دینار نیە
                </span>
                @endif
            </div>
            
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Transaction type toggle at the top -->
                        <div class="col-12">
                            <div class="form-check mb-3">
                                <input type="checkbox" id="withoutCustomerIQD" wire:model.live="withoutCustomerIQD" 
                                    class="form-check-input">
                                <label for="withoutCustomerIQD" class="form-check-label">
                                    {{ __('word.TransferWithoutAccount') }}
                                </label>
                            </div>
                              <!-- Added Money Transfer checkbox for IQD -->
                            <div class="form-check mb-3">
                                <input type="checkbox" id="moneyTransferOnlyIQD" wire:model.live="moneyTransferOnlyIQD" 
                                    class="form-check-input">
                                <label for="moneyTransferOnlyIQD" class="form-check-label">
                                    صرف حوالە
                                </label>
                            </div>
                        </div>
                        
                         <!-- Show these fields when customer without account is selected -->
                         @if($withoutCustomerIQD || $moneyTransferOnlyIQD)
                         <div class="col-md-6">
                             <div class="form-floating mb-3">
                                 <input type="text" id="sender_name_iqd" class="form-control" 
                                     wire:model.live="sender_name_iqd" placeholder="{{ __('word.SenderName') }}">
                                 <label for="sender_name_iqd">{{ __('word.SenderName') }}</label>
                                 @error('sender_name_iqd') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>
                         
                         <div class="col-md-6">
                             <div class="form-floating mb-3">
                                 <input type="text" id="sender_phone_iqd" class="form-control" 
                                     wire:model="sender_phone_iqd" placeholder="{{ __('word.PhoneNumber') }}">
                                 <label for="sender_phone_iqd">{{ __('word.PhoneNumber') }}</label>
                                 @error('sender_phone_iqd') <span class="text-danger small">{{ $message }}</span> @enderror
                             </div>
                         </div>
                         @else
                         <!-- Customer search for USD account when regular customer is selected -->
                         <div class="col-md-6">
                             <div class="position-relative" x-data="{ open: false }">
                                 <div class="form-floating mb-3">
                                     <input type="text" id="selectedCustomerIdIQD" class="form-control" 
                                         wire:model.live="searchCustomerIQD"
                                         placeholder="{{ __('word.SearchByNameOrPhone') }}"
                                         @focus="open = true; $wire.loadCustomersIQD()"
                                         @click.away="setTimeout(() => open = false, 200)">
                                     <label for="selectedCustomerIdIQD">{{ __('word.SearchCustomer') }}</label>
                                     @error('selectedCustomerIdIQD') <span class="text-danger small">{{ $message }}</span> @enderror
                                 </div>
                                 
                                 <!-- Hidden input to store the selected customer ID -->
                                 <input type="hidden" wire:model="selectedCustomerIdIQD">
                                 
                                 <div class="position-absolute w-100 mt-1 bg-white border rounded shadow" 
                                 x-show="open" 
                                      x-show="open"  style="max-height: 250px; overflow-y: auto; z-index: 1000;">
                                     <div  class="p-2 text-muted" x-show="!$wire.customersIQD.length">
                                         <i class="fas fa-info-circle me-1"></i> {{ __('word.NoResultsFound') }}
                                     </div>
                                     @foreach($customersIQD as $customer)
                                        @if($customer['customer_name'] !== 'Cashiers' && $customer['customer_name'] !== 'Bank (Cashboxes)')
                                         <a href="#" class="list-group-item list-group-item-action p-1 transition-all" 
                                             wire:key="customer-{{ $customer['id'] }}"
                                             wire:click.prevent="selectCustomerIQD({{ $customer['id'] }}); open = false;">
                                            ({{ $customer['id'] }}) - {{ $customer['customer_name'] }} - {{ $customer['phone_number'] }}
                                         </a>
                                        @endif
                                        <hr>
                                     @endforeach
                                 </div>
                             </div>
                         </div>
                         
                         <div class="col-md-6">
                             <div class="form-floating mb-3">
                                 <input type="text" id="sender_phone_iqd" class="form-control" 
                                     wire:model="sender_phone_iqd" readonly placeholder="{{ __('word.PhoneNumber') }}">
                                 <label for="sender_phone_iqd">{{ __('word.PhoneNumber') }}</label>
                             </div>
                         </div>
                         @endif
                        
                        <!-- Receiver information (for both modes) -->
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="receiver_name_iqd" class="form-control" 
                                    wire:model="receiver_name_iqd" placeholder="{{ __('word.ReceiverName') }}">
                                <label for="receiver_name_iqd">{{ __('word.ReceiverName') }}</label>
                                @error('receiver_name_iqd') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" id="receiver_phone_iqd" class="form-control" 
                                    wire:model="receiver_phone_iqd" placeholder="{{ __('word.PhoneNumber') }}">
                                <label for="receiver_phone_iqd">{{ __('word.PhoneNumber') }}</label>
                                @error('receiver_phone_iqd') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" 
                                    wire:model="create_transaction_amount_IQD" class="form-control" 
                                    id="transaction_amount_IQD" placeholder="{{ __('word.Amount') }}">
                                <label for="transaction_amount_IQD">{{ __('word.TransactionAmount') }}</label>
                                @error('create_transaction_amount_IQD') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                                                
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <select wire:model="create_transaction_type_IQD" class="form-select" id="transaction_type_IQD">
                                    @foreach($transactionTypes as $type)
                                        <option value="{{ $type }}">
                                            @if($type == 'deposit')
                                            {{ __('word.Deposit') }}
                                            @elseif($type == 'withdrawal')
                                            {{ __('word.Withdrawal') }}
                                            @elseif($type == 'transfer')
                                            {{ __('word.Transfer') }}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                <label for="transaction_type_IQD">{{ __('word.TransactionType') }}</label>
                                @error('create_transaction_type_IQD') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" x-mask:dynamic="$money($input, '.', ',', 4)" 
                                    wire:model="create_transaction_fee_IQD" class="form-control" 
                                    id="transaction_fee_IQD" placeholder="{{ __('word.Fee') }}">
                                <label for="transaction_fee_IQD">
                                      @if($withoutCustomerIQD)
                                         عمولەی {{ $this->sender_name_iqd}}
                                        @else
                                           {{ __('word.SenderFee') }}
                                        @endif 
                                </label>
                                @error('create_transaction_fee_IQD') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input x-mask:dynamic="$money($input, '.', ',', 4)" type="text" id="create_get_fee_IQD" 
                                    class="form-control" wire:model="create_get_fee_IQD" placeholder="{{ __('word.MyFee') }}">
                                <label for="create_get_fee_IQD">
                                    @if($withoutCustomerIQD)
                                     {{ __('word.CustomerFee', ['name' => $selectedCustomerName ?? 'الامان']) }}
                                    @else
                                        @if(isset($this->filters['customer']))
                                        {{ __('word.CustomerFee', ['name' => $selectedCustomerName ?? 'الامان']) }}
                                        @else
                                            {{ __('word.CustomerFee', ['name' => 'الامان']) }}
                                        @endif
                                    @endif    
                                </label>
                                @error('create_get_fee_IQD') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-check mb-2">
                                <input type="checkbox" id="showDigitalCurrency" wire:model.live="showDigitalCurrency" 
                                    class="form-check-input">
                                <label for="showDigitalCurrency" class="form-check-label">
                                    {{ __('word.Digital') }}
                                </label>
                            </div>
                            
                            @if ($showDigitalCurrency)
                            <div class="card border shadow-sm mt-2">
                                <div class="card-body p-2">
                                    <div class="row g-2">
                                        @foreach ($digitalCurrencies as $index => $currency)
                                        <div class="col-6">
                                            <div class="form-check">
                                                <input type="radio" id="currency_{{ $currency->id }}" 
                                                    wire:model="selectedDigitalCurrency"
                                                    value="{{ $currency->id }}" 
                                                    class="form-check-input">
                                                <label for="currency_{{ $currency->id }}" class="form-check-label">
                                                    {{ $currency->currency_name }}
                                                </label>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            @endif
                            @error('selectedDigitalCurrency') <span class="text-danger small">{{ $message }}</span> @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label for="file_IQD" class="form-label">{{ __('word.File') }}</label>
                            <input type="file" class="form-control" wire:model="file_IQD" id="file_IQD" accept="image/*">
                            @error('file_IQD') <span class="text-danger small">{{ $message }}</span> @enderror
                        </div>
                        
                        <div class="col-12">
                            <div class="form-floating mb-3">
                                <textarea wire:model="create_note_IQD" class="form-control" id="note_IQD" 
                                    placeholder="{{ __('word.Note') }}" style="height: 100px"></textarea>
                                <label for="note_IQD">{{ __('word.Note') }}</label>
                                @error('create_note_IQD') <span class="text-danger small">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-white border-top-0 pb-3">
                    <button wire:click="saveCreateIQD" type="submit" class="btn btn-success px-4 py-2">
                        <i class="fa fa-save me-2"></i> {{ __('word.Save') }}
                    </button>
                </div>
            </div>

            <!-- IQD Transactions Table -->
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white border-bottom-0 d-flex justify-content-between align-items-center pt-3">
                    <h5 class="card-title fw-bold text-success mb-0">
                        <i class="fa fa-history me-2"></i> حەرەکەکانی دینار
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>@lang('word.TransactionType')</th>
                                    <th>@lang('word.TransactionAmount')</th>
                                    <th>@lang('word.Fee')</th>
                                    <th>@lang('word.Balance')</th>
                                    <th>@lang('word.Date')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $customer_balance = 0;
                                    $currency_name = '';
                                @endphp
                                @if ($IQDAccount)
                                    @forelse ($IQDAccount->pendingTransactions
                                        // ->filter(fn($transaction) => $transaction->status === 'approved')
                                        ->filter(fn($transaction) => $transaction->transaction_type !== 'fee')
                                         as $transaction)
                                        @php
                                            $currency_name = $transaction->account->currency->currency_name;
                                            $previous_balance = $customer_balance;
                                            $transaction_amount = $transaction->transaction_amount;
                                            $transaction_fee = $transaction->fees->sum('fee_amount') ?? 0;
                                            
                                            if ($transaction->transaction_type == 'deposit') {
                                                $net_amount = $transaction_amount - $transaction_fee;
                                                $customer_balance += $net_amount;
                                            } elseif (in_array($transaction->transaction_type, ['transfer', 'withdrawal'])) {
                                                $total_deduction = $transaction_amount + $transaction_fee;
                                                $customer_balance -= $total_deduction;
                                            }
                                            
                                            $balance_change = $customer_balance - $previous_balance;
                                        @endphp
                                        <tr>
                                            <td>
                                                @if($transaction->transaction_type == 'deposit')
                                                <span class="badge bg-success rounded-pill">{{ __('word.Deposit') }}</span>
                                                @elseif($transaction->transaction_type == 'withdrawal')
                                                <span class="badge bg-danger rounded-pill">{{ __('word.Withdrawal') }}</span>
                                                @elseif($transaction->transaction_type == 'transfer')
                                                <span class="badge bg-primary rounded-pill">{{ __('word.Transfer') }}</span>
                                                @endif
                                            </td>
                                            <td>{{ number_format($transaction->transaction_amount, 0, '.', ',') }}</td>
                                            <td>{{ $transaction->get_fee }}</td>
                                            <td>
                                                {{ number_format($customer_balance, 0, '.', ',') }}
                                                @if ($balance_change > 0)
                                                    <span class="text-success ms-1"><i class="fa fa-arrow-up"></i></span>
                                                @elseif ($balance_change < 0)
                                                    <span class="text-danger ms-1"><i class="fa fa-arrow-down"></i></span>
                                                @endif
                                            </td>
                                            <td>{{ $transaction->transaction_time }} - {{ $transaction->transaction_date->format('Y-m-d') }}</td>
                                            <td>
                                                <a target="_blank" href="{{ route('invoice-transfer', [$transaction->id]) }}" class="btn btn-sm btn-outline-dark">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center py-3">@lang('word.Empty')</td>
                                        </tr>
                                    @endforelse
                                @else
                                    <tr>
                                        <td colspan="6" class="text-center py-3">@lang('word.NoAccountSelected')</td>
                                    </tr>
                                @endif
                            </tbody>
                            <tfoot class="table-light fw-bold">
                                <tr>
                                    <td colspan="3" class="text-end">{{ __('کۆی گشتی') }}</td>
                                    <td>{{ number_format($customer_balance, 0, '.', ',') }} {{ $currency_name }}</td>
                                    <td colspan="2"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </div>
    
  
    