<div>
    <div class="mb-4">
        @can('create', App\Models\AccountTransaction::class)
        <button class="btn btn-primary" wire:click="newAccountTransaction">
            <i class="icon ion-md-add"></i>
            @lang('crud.common.new')
        </button>
        @endcan @can('delete-any', App\Models\AccountTransaction::class)
        <button
            class="btn btn-danger"
             {{ empty($selected) ? 'disabled' : '' }} 
            onclick="confirm('Are you sure?') || event.stopImmediatePropagation()"
            wire:click="destroySelected"
        >
            <i class="icon ion-md-trash"></i>
            @lang('crud.common.delete_selected')
        </button>
        @endcan
    </div>

    <x-modal id="account-account-transactions-modal" wire:model="showingModal">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $modalTitle }}</h5>
                <button
                    type="button"
                    class="close"
                    data-dismiss="modal"
                    aria-label="Close"
                >
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div>
                    <x-inputs.group class="col-sm-12">
                        <x-inputs.select
                            name="accountTransaction.transaction_type"
                            label="Transaction Type"
                            wire:model="accountTransaction.transaction_type"
                        >
                            <option value="deposit" {{ $selected == 'deposit' ? 'selected' : '' }} >Deposit</option>
                            <option value="withdrawal" {{ $selected == 'withdrawal' ? 'selected' : '' }} >Withdrawal</option>
                            <option value="transfer" {{ $selected == 'transfer' ? 'selected' : '' }} >Transfer</option>
                        </x-inputs.select>
                    </x-inputs.group>

                    <x-inputs.group class="col-sm-12">
                        <x-inputs.number
                            name="accountTransaction.transaction_amount"
                            label="Transaction Amount"
                            wire:model="accountTransaction.transaction_amount"
                            max="255"
                            step="0.01"
                            placeholder="Transaction Amount"
                        ></x-inputs.number>
                    </x-inputs.group>

                    <x-inputs.group class="col-sm-12">
                        <x-inputs.date
                            name="accountTransactionTransactionDate"
                            label="Transaction Date"
                            wire:model="accountTransactionTransactionDate"
                            max="255"
                        ></x-inputs.date>
                    </x-inputs.group>

                    <x-inputs.group class="col-sm-12">
                        <x-inputs.text
                            name="accountTransaction.transaction_time"
                            label="Transaction Time"
                            wire:model="accountTransaction.transaction_time"
                            maxlength="255"
                            placeholder="Transaction Time"
                        ></x-inputs.text>
                    </x-inputs.group>

                    <x-inputs.group class="col-sm-12">
                        <x-inputs.textarea
                            name="accountTransaction.note"
                            label="Note"
                            wire:model="accountTransaction.note"
                            maxlength="255"
                        ></x-inputs.textarea>
                    </x-inputs.group>
                </div>
            </div>

            @if($editing) @endif

            <div class="modal-footer">
                <button
                    type="button"
                    class="btn btn-light float-left"
                    wire:click="$toggle('showingModal')"
                >
                    <i class="icon ion-md-close"></i>
                    @lang('crud.common.cancel')
                </button>

                <button type="button" class="btn btn-primary" wire:click="save">
                    <i class="icon ion-md-save"></i>
                    @lang('crud.common.save')
                </button>
            </div>
        </div>
    </x-modal>

    <div class="table-responsive">
        <table class="table table-borderless table-hover">
            <thead>
                <tr>
                    <th>
                        <input
                            type="checkbox"
                            wire:model="allSelected"
                            wire:click="toggleFullSelection"
                            title="{{ trans('crud.common.select_all') }}"
                        />
                    </th>
                    <th class="text-left">
                        @lang('crud.account_account_transactions.inputs.transaction_type')
                    </th>
                    <th class="text-right">
                        @lang('crud.account_account_transactions.inputs.transaction_amount')
                    </th>
                    <th class="text-left">
                        @lang('crud.account_account_transactions.inputs.transaction_date')
                    </th>
                    <th class="text-left">
                        @lang('crud.account_account_transactions.inputs.transaction_time')
                    </th>
                    <th class="text-left">
                        @lang('crud.account_account_transactions.inputs.note')
                    </th>
                    <th></th>
                </tr>
            </thead>
            <tbody class="text-gray-600">
                @foreach ($accountTransactions as $accountTransaction)
                <tr class="hover:bg-gray-100">
                    <td class="text-left">
                        <input
                            type="checkbox"
                            value="{{ $accountTransaction->id }}"
                            wire:model="selected"
                        />
                    </td>
                    <td class="text-left">
                        {{ $accountTransaction->transaction_type ?? '-' }}
                    </td>
                    <td class="text-right">
                        {{ $accountTransaction->transaction_amount ?? '-' }}
                    </td>
                    <td class="text-left">
                        {{ $accountTransaction->transaction_date ?? '-' }}
                    </td>
                    <td class="text-left">
                        {{ $accountTransaction->transaction_time ?? '-' }}
                    </td>
                    <td class="text-left">
                        {{ $accountTransaction->note ?? '-' }}
                    </td>
                    <td class="text-right" style="width: 134px;">
                        <div
                            role="group"
                            aria-label="Row Actions"
                            class="relative inline-flex align-middle"
                        >
                            @can('update', $accountTransaction)
                            <button
                                type="button"
                                class="btn btn-light"
                                wire:click="editAccountTransaction({{ $accountTransaction->id }})"
                            >
                                <i class="icon ion-md-create"></i>
                            </button>
                            @endcan
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="6">{{ $accountTransactions->render() }}</td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
