@php
$containerNav = ($configData['contentLayout'] === 'compact') ? 'container-xxl' : 'container-fluid';
$navbarDetached = ($navbarDetached ?? '');
@endphp

<style>
/* Modern Navbar Improvements */
#layout-navbar {
  backdrop-filter: blur(10px);
  box-shadow: 0 2px 20px rgba(0, 0, 0, 0.05);
  transition: all 0.3s ease;
  border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

[data-style="dark"] #layout-navbar {
  box-shadow: 0 2px 20px rgba(0, 0, 0, 0.3);
  border-bottom-color: rgba(255, 255, 255, 0.05);
}

/* Menu Toggle Button */
.layout-menu-toggle .nav-link {
  width: 40px;
  height: 40px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 0.5rem;
  transition: all 0.2s ease;
  background: transparent;
}

.layout-menu-toggle .nav-link:hover {
  background: rgba(102, 126, 234, 0.1);
  transform: scale(1.05);
}

[data-style="dark"] .layout-menu-toggle .nav-link:hover {
  background: rgba(102, 126, 234, 0.2);
}

.layout-menu-toggle .nav-link i {
  font-size: 1.5rem;
  color: #667eea;
  transition: transform 0.3s ease;
}

.layout-menu-toggle .nav-link:hover i {
  transform: rotate(90deg);
}

/* Style Switcher */
.dropdown-style-switcher .nav-link {
  width: 40px;
  height: 40px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 0.5rem;
  transition: all 0.2s ease;
  background: transparent;
  position: relative;
}

.dropdown-style-switcher .nav-link::before {
  content: '';
  position: absolute;
  inset: 0;
  border-radius: 0.5rem;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  opacity: 0;
  transition: opacity 0.2s ease;
}

.dropdown-style-switcher .nav-link:hover::before {
  opacity: 0.1;
}

[data-style="dark"] .dropdown-style-switcher .nav-link:hover::before {
  opacity: 0.2;
}

.dropdown-style-switcher .nav-link i {
  font-size: 1.375rem;
  color: #667eea;
  position: relative;
  z-index: 1;
}

.dropdown-styles {
  border-radius: 0.75rem !important;
  border: none !important;
  box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1) !important;
  padding: 0.5rem !important;
  min-width: 160px !important;
  margin-top: 0.5rem !important;
}

[data-style="dark"] .dropdown-styles {
  box-shadow: 0 10px 40px rgba(0, 0, 0, 0.4) !important;
  background: #2f3349 !important;
}

.dropdown-styles .dropdown-item {
  border-radius: 0.5rem !important;
  padding: 0.625rem 1rem !important;
  margin-bottom: 0.25rem !important;
  transition: all 0.2s ease !important;
  display: flex;
  align-items: center;
  gap: 0.5rem;
}

.dropdown-styles .dropdown-item:last-child {
  margin-bottom: 0 !important;
}

.dropdown-styles .dropdown-item:hover {
  background: linear-gradient(90deg, rgba(102, 126, 234, 0.1) 0%, rgba(102, 126, 234, 0.05) 100%) !important;
  transform: translateX(4px);
}

[data-style="dark"] .dropdown-styles .dropdown-item:hover {
  background: linear-gradient(90deg, rgba(102, 126, 234, 0.2) 0%, rgba(102, 126, 234, 0.1) 100%) !important;
}

.dropdown-styles .dropdown-item i {
  font-size: 1.125rem;
  color: #667eea;
}

/* User Dropdown */
.navbar-dropdown .avatar {
  width: 40px;
  height: 40px;
  border: 2px solid transparent;
  transition: all 0.3s ease;
  position: relative;
  background: linear-gradient(white, white) padding-box,
              linear-gradient(135deg, #667eea 0%, #764ba2 100%) border-box;
  border-radius: 50%;
}

[data-style="dark"] .navbar-dropdown .avatar {
  background: linear-gradient(#2f3349, #2f3349) padding-box,
              linear-gradient(135deg, #667eea 0%, #764ba2 100%) border-box;
}

.navbar-dropdown .nav-link:hover .avatar {
  transform: scale(1.05);
  box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.navbar-dropdown .avatar::before {
  content: '';
  position: absolute;
  inset: -2px;
  border-radius: 50%;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  z-index: -1;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.navbar-dropdown .nav-link:hover .avatar::before {
  opacity: 0.3;
}

.navbar-dropdown .dropdown-menu {
  border-radius: 0.75rem !important;
  border: none !important;
  box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15) !important;
  padding: 0.75rem !important;
  min-width: 280px !important;
  margin-top: 0.75rem !important;
}

[data-style="dark"] .navbar-dropdown .dropdown-menu {
  box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
  background: #2f3349 !important;
}

.navbar-dropdown .dropdown-item {
  border-radius: 0.5rem !important;
  padding: 0.75rem 1rem !important;
  margin-bottom: 0.25rem !important;
  transition: all 0.2s ease !important;
}

.navbar-dropdown .dropdown-item:hover {
  background: linear-gradient(90deg, rgba(102, 126, 234, 0.1) 0%, rgba(102, 126, 234, 0.05) 100%) !important;
  transform: translateX(4px);
}

[data-style="dark"] .navbar-dropdown .dropdown-item:hover {
  background: linear-gradient(90deg, rgba(102, 126, 234, 0.2) 0%, rgba(102, 126, 234, 0.1) 100%) !important;
}

.navbar-dropdown .dropdown-item i {
  color: #667eea;
  font-size: 1.125rem;
  transition: transform 0.2s ease;
}

.navbar-dropdown .dropdown-item:hover i {
  transform: scale(1.1);
}

.navbar-dropdown .dropdown-divider {
  margin: 0.75rem 0 !important;
  border-top: 1px solid rgba(0, 0, 0, 0.05) !important;
  background: linear-gradient(90deg, transparent, rgba(102, 126, 234, 0.2), transparent);
  height: 1px;
  border: none;
}

[data-style="dark"] .navbar-dropdown .dropdown-divider {
  background: linear-gradient(90deg, transparent, rgba(102, 126, 234, 0.3), transparent);
}

/* User Info in Dropdown */
.navbar-dropdown .dropdown-item:first-child {
  background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(102, 126, 234, 0.02) 100%) !important;
  border: 1px solid rgba(102, 126, 234, 0.1);
  margin-bottom: 0.5rem !important;
  padding: 1rem !important;
}

[data-style="dark"] .navbar-dropdown .dropdown-item:first-child {
  background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(102, 126, 234, 0.05) 100%) !important;
  border-color: rgba(102, 126, 234, 0.2);
}

.navbar-dropdown .dropdown-item:first-child:hover {
  transform: none;
}

.navbar-dropdown .dropdown-item .avatar {
  width: 48px;
  height: 48px;
}

.navbar-dropdown .dropdown-item .fw-medium {
  color: #333;
  font-size: 1rem;
  margin-bottom: 0.25rem;
}

[data-style="dark"] .navbar-dropdown .dropdown-item .fw-medium {
  color: #ddd;
}

/* Online Status Badge */
.avatar-online::before {
  content: '';
  position: absolute;
  bottom: 2px;
  right: 2px;
  width: 10px;
  height: 10px;
  background: #43e97b;
  border: 2px solid white;
  border-radius: 50%;
  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
  animation: pulse 2s ease-in-out infinite;
}

[data-style="dark"] .avatar-online::before {
  border-color: #2f3349;
}

@keyframes pulse {
  0%, 100% {
    transform: scale(1);
    opacity: 1;
  }
  50% {
    transform: scale(1.1);
    opacity: 0.8;
  }
}

/* Logout Item - Special Styling */
.navbar-dropdown .dropdown-item[href*="logout"] {
  color: #ff6b6b !important;
  background: rgba(255, 107, 107, 0.05) !important;
  border: 1px solid rgba(255, 107, 107, 0.1);
  margin-top: 0.5rem;
}

.navbar-dropdown .dropdown-item[href*="logout"]:hover {
  background: rgba(255, 107, 107, 0.1) !important;
  border-color: rgba(255, 107, 107, 0.2);
}

.navbar-dropdown .dropdown-item[href*="logout"] i {
  color: #ff6b6b !important;
}

/* Smooth Dropdown Animation */
.dropdown-menu {
  animation: slideDown 0.3s ease-out;
  transform-origin: top;
}

@keyframes slideDown {
  from {
    opacity: 0;
    transform: translateY(-10px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

/* Navbar Brand (if visible) */
.app-brand-text {
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  font-weight: 700;
}

/* Responsive Improvements */
@media (max-width: 1199.98px) {
  .navbar-dropdown .dropdown-menu {
    min-width: 260px !important;
  }
}

@media (max-width: 575.98px) {
  #layout-navbar {
    padding: 0.5rem 0 !important;
  }
  
  .navbar-dropdown .dropdown-menu {
    min-width: 240px !important;
    right: 0 !important;
    left: auto !important;
  }
}
</style>

<!-- Navbar -->
@if(isset($navbarDetached) && $navbarDetached == 'navbar-detached')
<nav class="layout-navbar {{$containerNav}} navbar navbar-expand-xl {{$navbarDetached}} align-items-center bg-navbar-theme" id="layout-navbar">
  @endif
  @if(isset($navbarDetached) && $navbarDetached == '')
  <nav class="layout-navbar navbar navbar-expand-xl align-items-center bg-navbar-theme" id="layout-navbar">
    <div class="{{$containerNav}}">
      @endif

      <!--  Brand demo (display only for navbar-full and hide on below xl) -->
      @if(isset($navbarFull))
      <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4">
        <a href="{{url('/')}}" class="app-brand-link gap-2">
          <span class="app-brand-logo demo">
            @include('_partials.macros',["height"=>20])
          </span>
          <span class="app-brand-text demo menu-text fw-bold">{{config('variables.templateName')}}</span>
        </a>
      </div>
      @endif

      <!-- ! Not required for layout-without-menu -->
      @if(!isset($navbarHideToggle))
      <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0{{ isset($menuHorizontal) ? ' d-xl-none ' : '' }} {{ isset($contentNavbar) ?' d-xl-none ' : '' }}">
        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
          <i class="ti ti-menu-2 ti-sm"></i>
        </a>
      </div>
      @endif

      <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">

        @if($configData['hasCustomizer'] == true)
        <!-- Style Switcher -->
        <div class="navbar-nav align-items-center">
          <div class="nav-item dropdown-style-switcher dropdown me-2 me-xl-0">
            <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
              <i class='ti ti-md'></i>
            </a>
            <ul class="dropdown-menu dropdown-menu-start dropdown-styles">
              <li>
                <a class="dropdown-item" href="javascript:void(0);" data-theme="light">
                  <i class='ti ti-sun'></i>
                  <span class="align-middle">Light</span>
                </a>
              </li>
              <li>
                <a class="dropdown-item" href="javascript:void(0);" data-theme="dark">
                  <i class="ti ti-moon"></i>
                  <span class="align-middle">Dark</span>
                </a>
              </li>
              <li>
                <a class="dropdown-item" href="javascript:void(0);" data-theme="system">
                  <i class="ti ti-device-desktop"></i>
                  <span class="align-middle">System</span>
                </a>
              </li>
            </ul>
          </div>
        </div>
        <!--/ Style Switcher -->
        @endif

        <ul class="navbar-nav flex-row align-items-center ms-auto">

          <!-- User -->
          <li class="nav-item navbar-dropdown dropdown-user dropdown">
            <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
              <div class="avatar avatar-online">
                <img src="/assets/Background.png" alt class="h-auto rounded-circle">
              </div>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
              <li>
                <a class="dropdown-item" href="{{ Route::has('profile.show') ? route('profile.show') : 'javascript:void(0);' }}">
                  <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                      <div class="avatar avatar-online">
                        <img src="/assets/Background.png" alt class="h-auto rounded-circle">
                      </div>
                    </div>
                    <div class="flex-grow-1">
                      <span class="fw-medium d-block">
                        @if (Auth::check())
                        {{ Auth::user()->name }}
                        @else
                        John Doe
                        @endif
                      </span>
                      <small class="text-muted">
                        @if (Auth::check())
                        {{ Auth::user()->roles->pluck('name')->join(', ') }}
                        @else
                        Guest
                        @endif
                      </small>
                    </div>
                  </div>
                </a>
              </li>
              <li>
                <div class="dropdown-divider"></div>
              </li>
              <li>
                <a class="dropdown-item" href="{{ Route::has('profile.show') ? route('profile.show') : 'javascript:void(0);' }}">
                  <i class="ti ti-user-check me-2 ti-sm"></i>
                  <span class="align-middle">@lang('word.MyProfile')</span>
                </a>
              </li>
              @if (Auth::check() && Laravel\Jetstream\Jetstream::hasApiFeatures())
              <li>
                <a class="dropdown-item" href="{{ route('api-tokens.index') }}">
                  <i class='ti ti-key me-2 ti-sm'></i>
                  <span class="align-middle">API Tokens</span>
                </a>
              </li>
              @endif

              @if (Auth::User() && Laravel\Jetstream\Jetstream::hasTeamFeatures())
              <li>
                <div class="dropdown-divider"></div>
              </li>
              <li>
                <h6 class="dropdown-header">Manage Team</h6>
              </li>
              <li>
                <div class="dropdown-divider"></div>
              </li>
              <li>
                <a class="dropdown-item" href="{{ Auth::user() ? route('teams.show', Auth::user()->currentTeam->id) : 'javascript:void(0)' }}">
                  <i class='ti ti-settings me-2'></i>
                  <span class="align-middle">Team Settings</span>
                </a>
              </li>
              @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
              <li>
                <a class="dropdown-item" href="{{ route('teams.create') }}">
                  <i class='ti ti-user me-2'></i>
                  <span class="align-middle">Create New Team</span>
                </a>
              </li>
              @endcan
              @if (Auth::user()->allTeams()->count() > 1)
              <li>
                <div class="dropdown-divider"></div>
              </li>
              <li>
                <h6 class="dropdown-header">Switch Teams</h6>
              </li>
              <li>
                <div class="dropdown-divider"></div>
              </li>
              @endif
              @if (Auth::user())
              @foreach (Auth::user()->allTeams() as $team)
              {{-- Below commented code read by artisan command while installing jetstream. !! Do not remove if you want to use jetstream. --}}

              <x-switchable-team :team="$team" />
              @endforeach
              @endif
              @endif
              <li>
                <div class="dropdown-divider"></div>
              </li>
              @if (Auth::check())
              <li>
                <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                  <i class='ti ti-logout me-2'></i>
                  <span class="align-middle">@lang('word.Logout')</span>
                </a>
              </li>
              <form method="POST" id="logout-form" action="{{ route('logout') }}">
                @csrf
              </form>
              @else
              <li>
                <a class="dropdown-item" href="{{ Route::has('login') ? route('login') : url('auth/login-basic') }}">
                  <i class='ti ti-login me-2'></i>
                  <span class="align-middle">Login</span>
                </a>
              </li>
              @endif
            </ul>
          </li>
          <!--/ User -->
        </ul>
      </div>

      @if(!isset($navbarDetached))
    </div>
    @endif
  </nav>
  <!-- / Navbar -->
