@extends('layouts/layoutMaster')

@section('title', 'Show transactions')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('transactions.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.transactions.show_title')
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>@lang('crud.transactions.inputs.transaction_date')</h5>
                    <span>{{ $transaction->transaction_date ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.transactions.inputs.transaction_time')</h5>
                    <span>{{ $transaction->transaction_time ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>
                        @lang('crud.transactions.inputs.transaction_amount')
                    </h5>
                    <span>{{ $transaction->transaction_amount ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.transactions.inputs.transaction_type')</h5>
                    <span>{{ $transaction->transaction_type ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.transactions.inputs.from_currency')</h5>
                    <span
                        >{{ optional($transaction->from_currency)->currency_name
                        ?? '-' }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.transactions.inputs.to_currency')</h5>
                    <span
                        >{{ optional($transaction->to_currency)->currency_name
                        ?? '-' }}</span
                    >
                </div>
            </div>

            <div class="mt-4">
                <a
                    href="{{ route('transactions.index') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-return-left"></i>
                    @lang('crud.common.back')
                </a>

                @can('create', App\Models\Transaction::class)
                <a
                    href="{{ route('transactions.create') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection
