
<!DOCTYPE html>
<html>
<header>

    
<!-- Preload the font -->
<link rel="preload" href="{{ asset('fonts/NRT-Bd.ttf') }}" as="font" type="font/ttf" crossorigin="anonymous">

<style type="text/css">
  @font-face {
      font-family: 'rudawregular2';
      src: url('{{ asset('fonts/NRT-Bd.ttf') }}') format('truetype');
      font-display: swap;
  }
 
</style>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        /* General styles for the invoice */
        @page {
            size: A4 portrait;
            margin: 0;
        }

        body {
            font-family: 'rudawregular2', sans-serif;
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .logo {
            width: 150px;
            height: auto;
            margin: 0 auto;
        }

        .transaction-info {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        .customer-info {
            margin-top: 20px;
        }

        .customer-info {
        margin-top: 20px;
    }

    .invoice-type {
        flex: 1;
        display: flex;
        justify-content: center;
    }

    .invoice-type-box {
        background-color: #f0f0f0;
        border: 1px solid #ccc;
        padding: 10px 15px;
        font-size: 16px;
        font-weight: bold;
        text-align: center;
        border-radius: 5px;
        box-shadow: 1px 1px 5px rgba(0, 0, 0, 0.1);
        max-width: 150px;
        width: 100%;
    }

    .contact-info {
        direction: ltr;
        unicode-bidi: embed;
        text-align: left;
        display: inline-block;
    }

    .customer-row,
    .amount-row,
    .note-row {
        margin: 15px;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .customer-name,
    .amount-label,
    .note-label {
        font-size: 16px;
        font-weight: bold;
        margin: 0;
    }

    .customer-name-value,
    .amount-value,
    .note-value {
        margin: 10px;
        flex-grow: 1;
        text-align: right;
        position: relative;
    }

    .customer-name-value::after,
    .amount-value::after,
    .note-value::after {
        content: '';
        display: block;
        border-bottom: 1px dotted black;
        margin-top: 5px;
        width: 100%;
        position: absolute;
        left: 0;
        bottom: 0;
    }
    /* Dotted line between copies */
    .dotted-separator {
            border: none;
            border-top: 1px dotted black;
            margin: 20px 0;
        }

        /* Ensure both copies print on the same page */
        @media print {
            body * {
                visibility: hidden;
            }

            .invoice-copy, .invoice-copy * {
                visibility: visible;
            }
            .dotted-separator{
                visibility: visible;

            }

            .invoice-copy {
                position: relative;
                width: 100%;
                margin-bottom: 20px;
            }

            #printButton {
                display: none;
            }
        }
    </style>
</header>

<body dir="rtl">
<!-- Print Button -->
<div style="text-align: right; margin-bottom: 10px;">
    <button id="printButton" class="btn btn-primary" onclick="printInvoice()">Print Invoice</button>
</div>

<!-- First Copy -->
<div style="height: 50%;width:100%;margin-top:30px;"  class="invoice-copy ">

    <div class="header">
        <div class="row">
            <div class="col-4">
                <h1>الامان</h1>
                <p>بۆ ئاڵوگۆڕی دراو</p>
                <p>هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى</p>
            </div>
            <div class="col-4">
                <img src="/assets/logoback.png" alt="al-aman Logo" class="logo">
            </div>
            <div class="col-4">
                <h1>al-aman</h1>
                <p>al-aman for Clinic</p>
                <p class="contact-info">Mobile - 0751 825 3732 <br>
                    0751 466 8873,
                    0751 531 4173</p>
            </div>
        </div>
    </div>
    <div class="transaction-info">
        <div class="invoice-type">
            <div style="margin-right: 180px;" class="invoice-type-box">
                @if($select_transaction->transaction_type == 'sell')
                {{ __('word.Sell') }}
                @elseif($select_transaction->transaction_type == 'buy')
                {{ __('word.Buy') }}
                @endif

                </div>
        </div>
        <div style="margin-left: 10px;" class="invoice-info">
            Invoice No: {{$select_transaction->id}}
            <br>
            Date: {{$select_transaction->transaction_date->format('Y-m-d')}}
        </div>
    </div>

    <div class="customer-info">
        <div class="customer-row">
            <p class="customer-name">@lang('word.Dear'):</p>
            <p class="customer-name-value">  {{$select_transaction->note ?? '_'}}</p>
        </div>
        <div class="row">
            <div class="col-6 ">
                <div class="amount-row">
                <p class="amount-label">@lang('word.AmountGiven'):</p>
                <p class="amount-value">
                    {{ number_format($select_transaction->amount_given, 0, '.', ',') }}  | {{convertNumberToWordsKurdishSorani($select_transaction->amount_given) }} {{ $select_transaction->to_currency_code->currency_name }}
                </p>
                </div>
            </div>
            <div class="col-6 ">
                <div class="amount-row">
                <p class="amount-label">@lang('word.AmountReceived'):</p>
                <p class="amount-value">
                    {{ number_format($select_transaction->amount_received, 0, '.', ',') }}  | {{convertNumberToWordsKurdishSorani($select_transaction->amount_received) }} {{ $select_transaction->from_currency_code->currency_name }}
                </p>
                </div>
            </div>
        </div>
        <div class="note-row">
            <p class="note-label">@lang('word.Fee'):</p>
            <?php 
                $fee = $select_transaction->fees->first();
            ?>
            <p class="note-value">
                <?php if($fee): ?>
                    <?php echo e($fee->fee_amount); ?> | <?php echo e(convertNumberToWordsKurdishSorani($fee->fee_amount)); ?>
                <?php else: ?>
                   0
                <?php endif; ?>
            </p>
        </div>
    </div>

    <div align="center" class="row">
        <div class="col-4">
            <p>ئیمزای وەرگر</p>
        </div>
        <div class="col-4">
        </div>
        <div class="col-4">
            <p>ئیمزای پێدەر</p>
        </div>
    </div>
</div>

  <!-- Dotted line separator -->
  <hr class="dotted-separator" style="margin-top:30px;">
  
<!-- Second Copy -->
<div style="height: 50%;width:100%; margin-top:30px;"  class="invoice-copy ">
    <div class="header">
        <div class="row">
            <div class="col-4">
                <h1>الامان</h1>
                <p>بۆ ئاڵوگۆڕی دراو</p>
                <p>هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى</p>
            </div>
            <div class="col-4">
                <img src="/assets/logoback.png" alt="al-aman Logo" class="logo">
            </div>
            <div class="col-4">
                <h1>al-aman</h1>
                <p>al-aman for Clinic</p>
                <p class="contact-info">Mobile - 0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173</p>
            </div>
        </div>
    </div>
    <div class="transaction-info">
        <div class="invoice-type">
            <div style="margin-right: 180px;" class="invoice-type-box">
                @if($select_transaction->transaction_type == 'sell')
                {{ __('word.Sell') }}
                @elseif($select_transaction->transaction_type == 'buy')
                {{ __('word.Buy') }}
                @endif

                </div>
        </div>
        <div style="margin-left: 20px;" class="invoice-info">
            Invoice No: {{$select_transaction->id}}
            <br>
            Date: {{$select_transaction->transaction_date->format('Y-m-d')}}
        </div>
    </div>

    <div class="customer-info">
        <div class="customer-row">
            <p class="customer-name">@lang('word.Dear'):</p>
            <p class="customer-name-value">  {{$select_transaction->note ?? '_'}}</p>
        </div>
        <div class="row">
            <div class="col-6 ">
                <div class="amount-row">
                <p class="amount-label">@lang('word.AmountGiven'):</p>
                <p class="amount-value">
                    {{ number_format($select_transaction->amount_given, 0, '.', ',') }} | {{convertNumberToWordsKurdishSorani($select_transaction->amount_given) }}  {{ $select_transaction->to_currency_code->currency_name }}
                </p>
                </div>
            </div>
            <div class="col-6 ">
                <div class="amount-row">
                <p class="amount-label">@lang('word.AmountReceived'):</p>
                <p class="amount-value">
                    {{ number_format($select_transaction->amount_received, 0, '.', ',') }} | {{convertNumberToWordsKurdishSorani($select_transaction->amount_received) }} {{ $select_transaction->from_currency_code->currency_name }}
                </p>
                </div>
            </div>
        </div>
        <div class="note-row">
            <p class="note-label">@lang('word.Fee'):</p>
            <?php 
                $fee = $select_transaction->fees->first();
            ?>
            <p class="note-value">
                <?php if($fee): ?>
                    <?php echo e($fee->fee_amount); ?> | <?php echo e(convertNumberToWordsKurdishSorani($fee->fee_amount)); ?>
                <?php else: ?>
                    0
                <?php endif; ?>
            </p>
            </div>
    </div>

    <div align="center" class="row">
        <div class="col-4">
            <p>ئیمزای وەرگر</p>
        </div>
        <div class="col-4">

        </div>
        <div class="col-4">
            <p>ئیمزای پێدەر</p>
        </div>
    </div>
</div>



<script>
    function printInvoice() {
        window.print();
    }
</script>
</body>
</html>
