<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>POS Invoice</title>
    <style>
        body {
            font-family: 'Courier', monospace;
            width: 80mm;
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .header .logo {
            max-width: 60px;
            height: auto;
            margin: 0 auto;
        }

        .transaction-info,
        .customer-info {
            margin: 10px 0;
            font-size: 14px;
        }

        .line {
            border-top: 1px dashed black;
            margin: 5px 0;
        }

        .details {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
        }

        .total {
            font-size: 14px;
            font-weight: bold;
        }

        .footer {
            text-align: center;
            margin-top: 10px;
            font-size: 12px;
        }

        .contact-info {
            direction: ltr;
            unicode-bidi: embed;
            text-align: left;
            display: inline-block;
        }

        @media print {
            #printButton {
                display: none;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <div style="text-align: right; margin-bottom: 10px;">
        <button id="printButton" onclick="window.print()">Print</button>
    </div>

    <!-- Invoice -->
    <div class="header">
        <h2>دراوەکان</h2>
        <p>بۆ ئاڵوگۆڕی دراو</p>
        <img src="/assets/logoback.png" alt="Logo" class="logo">
        <h2>al-aman</h2>
        <p>al-aman for Clinic</p>
        <p class="contact-info">0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173</p>
    </div>

    <div class="transaction-info">
        <p>Invoice No: {{$select_transaction->id}}</p>
        <p>Date: {{$select_transaction->transaction_date->format('Y-m-d')}}</p>
    </div>

    <hr class="line">

    <div class="customer-info">
        <p>Dear: {{$select_transaction->note ?? '_'}}</p>
        <p class="details">
            <span>Amount Given:</span>
            <span>{{ number_format($select_transaction->amount_given, 0, '.', ',') }}</span>
        </p>
        <p class="details">
            <span>Amount Received:</span>
            <span>{{ number_format($select_transaction->amount_received, 0, '.', ',') }}</span>
        </p>
        <p class="details">
            <span>Fee:</span>
            <span>{{ $select_transaction->fees->first()->fee_amount ?? '0' }}</span>
        </p>
    </div>

    <hr class="line">

    <div class="footer">
        <p>Thank You for Your Business!</p>
        <p>ئیمزای وەرگر</p>
    </div>
</body>
</html>
