@php $editing = isset($transaction) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12">
        <x-inputs.date
            name="transaction_date"
            label="Transaction Date"
            value="{{ old('transaction_date', ($editing ? optional($transaction->transaction_date)->format('Y-m-d') : '')) }}"
            max="255"
            required
        ></x-inputs.date>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.text
            name="transaction_time"
            label="Transaction Time"
            :value="old('transaction_time', ($editing ? $transaction->transaction_time : ''))"
            maxlength="255"
            placeholder="Transaction Time"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.number
            name="transaction_amount"
            label="Transaction Amount"
            :value="old('transaction_amount', ($editing ? $transaction->transaction_amount : ''))"
            max="255"
            step="0.01"
            placeholder="Transaction Amount"
            required
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="transaction_type" label="Transaction Type">
            @php $selected = old('transaction_type', ($editing ? $transaction->transaction_type : '')) @endphp
            <option value="sell" {{ $selected == 'sell' ? 'selected' : '' }} >Sell</option>
            <option value="buy" {{ $selected == 'buy' ? 'selected' : '' }} >Buy</option>
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="from_currency" label="From Currency" required>
            @php $selected = old('from_currency', ($editing ? $transaction->from_currency : '')) @endphp
            <option disabled {{ empty($selected) ? 'selected' : '' }}>Please select the Currency</option>
            @foreach($currencies as $value => $label)
            <option value="{{ $value }}" {{ $selected == $value ? 'selected' : '' }} >{{ $label }}</option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="to_currency" label="To Currency" required>
            @php $selected = old('to_currency', ($editing ? $transaction->to_currency : '')) @endphp
            <option disabled {{ empty($selected) ? 'selected' : '' }}>Please select the Currency</option>
            @foreach($currencies as $value => $label)
            <option value="{{ $value }}" {{ $selected == $value ? 'selected' : '' }} >{{ $label }}</option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>
</div>
