@extends('layouts/layoutMaster')
@section('title', 'Show Subcategory')

@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('subcategories.index') }}" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Subcategory
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Name</h5>
                    <span>{{ $subcategory->name ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Category</h5>
                    <span>{{ $subcategory->category->name ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Cost</h5>
                    <span>{{ number_format($subcategory->cost, 2) ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Description</h5>
                    <span>{{ $subcategory->description ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Sort Order</h5>
                    <span>{{ $subcategory->sort_order ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a href="{{ route('subcategories.index') }}" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                @can('update', $subcategory)
                <a href="{{ route('subcategories.edit', $subcategory) }}" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection

