@extends('layouts/layoutMaster')
@section('title', 'Product Profile')

@section('content')
<div>
  <!-- Product Profile Content -->
  <div class="row">
      <div class="col-xl-4 col-lg-5 col-md-5">
          <!-- About Product -->
          <div class="card mb-4">
              <div class="card-body">
                  <div class="d-flex align-items-center justify-content-center" style="text-align: center; height: 100%;">
                      <div class="badge rounded-pill bg-label-primary">
                          <i class="menu-icon tf-icons ti ti-package" style="font-size: 72px;"></i>
                      </div>
                  </div>
                  
                  <ul class="list-unstyled mb-4 mt-3">
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-file-invoice"></i>
                          <span class="fw-bold mx-2">Product Name:</span>
                          <span>{{ $product->name ?? '-' }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Sale Price:</span>
                          <span class="badge bg-primary">{{ number_format($product->sale_price, 2) }} $</span>
                      </li>
                      @if($product->purchase_price)
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Purchase Price:</span>
                          <span class="badge bg-info">{{ number_format($product->purchase_price, 2) }} $</span>
                      </li>
                      @endif
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-box"></i>
                          <span class="fw-bold mx-2">Stock Quantity:</span>
                          <span>{{ $product->stock_quantity ?? 0 }}</span>
                      </li>
                      @if($product->expired_date)
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-calendar"></i>
                          <span class="fw-bold mx-2">Expired Date:</span>
                          <span>{{ $product->expired_date->format('M d, Y') }}</span>
                      </li>
                      @endif
                      @if($product->supplier)
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-truck"></i>
                          <span class="fw-bold mx-2">Supplier:</span>
                          <span>{{ $product->supplier->name ?? '-' }}</span>
                      </li>
                      @endif
                      @if($product->description)
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-file-text"></i>
                          <span class="fw-bold mx-2">Description:</span>
                          <span>{{ Str::limit($product->description, 50) }}</span>
                      </li>
                      @endif
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-box"></i>
                          <span class="fw-bold mx-2">Total Batches:</span>
                          <span class="badge bg-success">{{ $product->batches->count() }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-receipt"></i>
                          <span class="fw-bold mx-2">Times Sold:</span>
                          <span class="badge bg-warning">{{ $product->invoiceItems->count() }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Total Revenue:</span>
                          <span class="badge bg-success">{{ number_format($product->invoiceItems->sum('total_price'), 2) }} $</span>
                      </li>
                  </ul>

                  <div class="row d-flex justify-content-center align-items-center">
                    @can('update', $product)
                    <div class="col-md-12 mb-2">
                      <a href="{{ route('products.edit', $product) }}" class="btn btn-primary w-100">
                        <i class="tf-icons ti ti-edit"></i> Edit Product
                      </a>
                    </div>
                    @endcan
                    <div class="col-md-12 mb-2">
                      <a href="{{ route('products.index') }}" class="btn btn-outline-secondary w-100">
                        <i class="tf-icons ti ti-arrow-left"></i> Back to List
                      </a>
                    </div>
                  </div>
              </div>
          </div>
      </div>
      
      <div class="col-xl-8 col-lg-7 col-md-7">
          <!-- Activity Timeline -->
          <div class="col-xl-12">
              <div class="nav-align-top mb-4">
                  <div class="dropdown">
                      {{-- Tabs --}}
                      <ul class="nav nav-pills mb-3" role="tablist">
                        <li class="nav-item">
                          <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#sales" aria-controls="sales" aria-selected="true">Sales History</button>
                        </li>
                        <li class="nav-item">
                          <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#batches" aria-controls="batches" aria-selected="false">Product Batches</button>
                        </li>
                      </ul>
                      {{-- / Tabs --}}
                  </div>
                  
                  {{-- Tabs Content --}}
                  <div class="tab-content">
                    {{-- Tab Sales History --}}
                     <div class="tab-pane fade show active" id="sales" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Invoice Number</th>
                              <th class="text-left text-primary">Patient</th>
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Quantity</th>
                              <th class="text-left text-primary">Unit Price</th>
                              <th class="text-left text-primary">Total</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            @forelse($invoiceItems as $item)
                            <tr>
                              <td>{{ $item->invoice->invoice_number ?? '-' }}</td>
                              <td>{{ $item->invoice->patient->name ?? '-' }} ({{ $item->invoice->patient->code ?? '-' }})</td>
                              <td>{{ $item->invoice->invoice_date ? $item->invoice->invoice_date->format('M d, Y') : '-' }}</td>
                              <td><strong>{{ $item->quantity }}</strong></td>
                              <td>{{ number_format($item->unit_price, 2) }} $</td>
                              <td><strong class="text-primary">{{ number_format($item->total_price, 2) }} $</strong></td>
                              <td class="text-center" style="width: 134px;">
                                <div role="group" aria-label="Row Actions" class="btn-group">
                                  <a href="{{ route('invoices.show', $item->invoice) }}">
                                    <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                      <i class="fa fa-eye"></i>
                                    </button>
                                  </a>
                                </div>
                              </td>
                            </tr>
                            @empty
                            <tr>
                              <td colspan="7" class="text-center py-4">
                                <p class="text-muted">This product has not been sold yet</p>
                              </td>
                            </tr>
                            @endforelse
                          </tbody>
                        </table>
                        <br>
                        <div style="float: right" class="d-flex justify-content-start align-items-start">
                          {{ $invoiceItems->links() }}
                        </div>
                      </div>
                     </div>

                    {{-- Tab Batches --}}
                     <div class="tab-pane fade" id="batches" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Batch Number</th>
                              <th class="text-left text-primary">Purchase Date</th>
                              <th class="text-left text-primary">Expired Date</th>
                              <th class="text-left text-primary">Quantity</th>
                              <th class="text-left text-primary">Sold</th>
                              <th class="text-left text-primary">Returned</th>
                              <th class="text-left text-primary">Available</th>
                              <th class="text-left text-primary">Purchase Price</th>
                            </tr>
                          </thead>
                          <tbody>
                            @forelse($product->batches as $batch)
                            <tr>
                              <td><strong>{{ $batch->batch_number ?? '-' }}</strong></td>
                              <td>{{ $batch->purchase_date ? $batch->purchase_date->format('M d, Y') : '-' }}</td>
                              <td>{{ $batch->expired_date ? $batch->expired_date->format('M d, Y') : '-' }}</td>
                              <td>{{ $batch->quantity }}</td>
                              <td><span class="badge bg-warning">{{ $batch->sold_quantity }}</span></td>
                              <td><span class="badge bg-info">{{ $batch->returned_quantity }}</span></td>
                              <td><span class="badge bg-success">{{ $batch->available_quantity }}</span></td>
                              <td>{{ number_format($batch->purchase_price, 2) }} $</td>
                            </tr>
                            @empty
                            <tr>
                              <td colspan="8" class="text-center py-4">
                                <p class="text-muted">No batches found for this product</p>
                              </td>
                            </tr>
                            @endforelse
                          </tbody>
                        </table>
                      </div>
                     </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
