@php $editing = isset($product) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="name"
            label="Product Name"
            :value="old('name', ($editing ? $product->name : ''))"
            maxlength="255"
            placeholder="Product Name"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="sale_price"
            label="Sale Price"
            :value="old('sale_price', ($editing ? $product->sale_price : ''))"
            step="0.01"
            placeholder="Sale Price"
            required
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="purchase_price"
            label="Purchase Price"
            :value="old('purchase_price', ($editing ? $product->purchase_price : ''))"
            step="0.01"
            placeholder="Purchase Price"
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.select name="supplier_id" label="Supplier">
            <option value="">Select Supplier</option>
            @foreach($suppliers as $id => $name)
                <option value="{{ $id }}" {{ old('supplier_id', ($editing ? $product->supplier_id : '')) == $id ? 'selected' : '' }}>
                    {{ $name }}
                </option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.date
            name="expired_date"
            label="Expired Date"
            :value="old('expired_date', ($editing ? $product->expired_date : ''))"
        ></x-inputs.date>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="stock_quantity"
            label="Stock Quantity"
            :value="old('stock_quantity', ($editing ? $product->stock_quantity : '0'))"
            placeholder="Stock Quantity"
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.textarea name="description" label="Description"
            >{{ old('description', ($editing ? $product->description : '')) }}</x-inputs.textarea
        >
    </x-inputs.group>
</div>

