@extends('layouts/layoutMaster')
@section('title', 'Patient Profile')

@section('content')
<div>
  <!-- Patient Profile Content -->
  <div class="row">
      <div class="col-xl-4 col-lg-5 col-md-5">
          <!-- About Patient -->
          <div class="card mb-4">
              <div class="card-body">
                  <div class="d-flex align-items-center justify-content-center" style="text-align: center; height: 100%;">
                      <div class="badge rounded-pill bg-label-primary">
                          <i class="menu-icon tf-icons ti ti-user" style="font-size: 72px;"></i>
                      </div>
                  </div>
                  
                  <ul class="list-unstyled mb-4 mt-3">
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-id"></i>
                          <span class="fw-bold mx-2">Patient Code:</span>
                          <span>{{ $patient->code ?? '-' }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-user"></i>
                          <span class="fw-bold mx-2">Patient Name:</span>
                          <span>{{ $patient->name ?? '-' }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-phone"></i>
                          <span class="fw-bold mx-2">Phone:</span>
                          <span>{{ $patient->phone ?? '-' }}</span>
                      </li>
                      @if($patient->address)
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-map-pin"></i>
                          <span class="fw-bold mx-2">Address:</span>
                          <span>{{ $patient->address }}</span>
                      </li>
                      @endif
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-calendar"></i>
                          <span class="fw-bold mx-2">Member Since:</span>
                          <span>{{ $patient->created_at ? $patient->created_at->format('M d, Y') : '-' }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-receipt"></i>
                          <span class="fw-bold mx-2">Total Invoices:</span>
                          <span class="badge bg-primary">{{ $patient->invoices->count() }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-currency-dollar"></i>
                          <span class="fw-bold mx-2">Total Spent:</span>
                          <span class="badge bg-success">{{ number_format($patient->invoices->sum('total_amount'), 2) }}</span>
                      </li>
                      <li class="d-flex align-items-center mb-3">
                          <i class="ti ti-file-text"></i>
                          <span class="fw-bold mx-2">Medical Records:</span>
                          <span class="badge bg-info">{{ $patient->histories->count() }}</span>
                      </li>
                  </ul>

                  <div class="row d-flex justify-content-center align-items-center">
                  
                    @can('update', $patient)
                    <div class="col-md-12 mb-2">
                      <a href="{{ route('patients.edit', $patient) }}" class="btn btn-outline-info w-100">
                        <i class="tf-icons ti ti-edit"></i> Edit Patient
                      </a>
                    </div>
                    @endcan
                  </div>
              </div>
          </div>
      </div>
      
      <div class="col-xl-8 col-lg-7 col-md-7">
          <!-- Activity Timeline -->
          <div class="col-xl-12">
              <div class="nav-align-top mb-4">
                  <div class="dropdown">
                      {{-- Tabs --}}
                      <ul class="nav nav-pills mb-3" role="tablist">
                        <li class="nav-item">
                          <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#invoices" aria-controls="invoices" aria-selected="true">Invoice History</button>
                        </li>
                        {{-- <li class="nav-item">
                          <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#histories" aria-controls="histories" aria-selected="false">Medical History</button>
                        </li> --}}
                      </ul>
                      {{-- / Tabs --}}
                  </div>
                  
                  {{-- Tabs Content --}}
                  <div class="tab-content">
                    {{-- Tab Invoices --}}
                     <div class="tab-pane fade show active" id="invoices" role="tabpanel">
                      <div class="d-flex justify-content-end mb-3">
                        {{-- <a href="{{ route('invoices.create', ['patient_id' => $patient->id]) }}" class="btn btn-primary">
                          <i class="ti ti-plus me-2"></i>New Invoice
                        </a> --}}
                      </div>
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Invoice Number</th>
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Amount</th>
                              <th class="text-left text-primary">Status</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            @forelse($patient->invoices as $invoice)
                            <tr>
                              <td>{{ $invoice->invoice_number ?? '-' }}</td>
                              <td>{{ $invoice->invoice_date ? $invoice->invoice_date->format('M d, Y') : '-' }}</td>
                              <td><strong>{{ number_format($invoice->total_amount, 2) }}</strong></td>
                              <td>
                                <span class="badge bg-{{ $invoice->status === 'completed' ? 'success' : ($invoice->status === 'cancelled' ? 'danger' : 'warning') }}">
                                  {{ ucfirst($invoice->status) }}
                                </span>
                              </td>
                              <td class="text-center" style="width: 134px;">
                                <div role="group" aria-label="Row Actions" class="btn-group">
                                  <a href="{{ route('invoices.show', $invoice) }}">
                                    <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                      <i class="fa fa-eye"></i>
                                    </button>
                                  </a>
                                </div>
                              </td>
                            </tr>
                            @empty
                            <tr>
                              <td colspan="5" class="text-center py-4">
                                <p class="text-muted">No invoices found for this patient</p>
                                <a href="{{ route('invoices.create', ['patient_id' => $patient->id]) }}" class="btn btn-primary">
                                  <i class="ti ti-plus me-2"></i>Create First Invoice
                                </a>
                              </td>
                            </tr>
                            @endforelse
                          </tbody>
                        </table>
                      </div>
                     </div>

                    {{-- Tab Histories --}}
                     <div class="tab-pane fade" id="histories" role="tabpanel">
                      <div class="table-responsive">
                        <table class="table">
                          <thead>
                            <tr class="border-bottom">
                              <th class="text-left text-primary">Date</th>
                              <th class="text-left text-primary">Type</th>
                              <th class="text-left text-primary">Notes</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            @forelse($patient->histories as $history)
                            <tr>
                              <td>{{ $history->history_date ? $history->history_date->format('M d, Y') : '-' }}</td>
                              <td>{{ $history->history_type ?? 'General' }}</td>
                              <td>{{ Str::limit($history->history_notes, 100) }}</td>
                              <td class="text-center" style="width: 134px;">
                                <div role="group" aria-label="Row Actions" class="btn-group">
                                  <a href="{{ route('patient-histories.show', $history) }}">
                                    <button type="button" class="btn btn-icon btn-outline-primary m-1">
                                      <i class="fa fa-eye"></i>
                                    </button>
                                  </a>
                                </div>
                              </td>
                            </tr>
                            @empty
                            <tr>
                              <td colspan="4" class="text-center py-4">
                                <p class="text-muted">No medical history recorded</p>
                              </td>
                            </tr>
                            @endforelse
                          </tbody>
                        </table>
                      </div>
                     </div>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
