@extends('layouts/layoutMaster')

@section('title', 'System Logs')

@section('page-style')
<link rel="stylesheet" href="{{asset('assets/vendor/css/pages/page-icons.css')}}" />
<style>
    .filter-card {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 20px;
    }
    .quick-filter-btn {
        margin: 5px;
    }
    .log-row {
        transition: all 0.2s ease;
    }
    .log-row:hover {
        background-color: #f5f5f5;
        cursor: pointer;
    }
    .badge-custom {
        font-size: 0.75rem;
        padding: 0.35rem 0.65rem;
    }
    .properties-section {
        background: #f8f9fa;
        padding: 10px;
        border-radius: 5px;
        font-size: 0.85rem;
    }
    .properties-section ul {
        margin-bottom: 0;
        padding-left: 20px;
    }
    .filter-badge {
        display: inline-flex;
        align-items: center;
        margin: 5px;
    }
    .clear-filter {
        margin-left: 5px;
        cursor: pointer;
    }
    .stats-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 20px;
    }
    .stats-item {
        text-align: center;
    }
    .stats-number {
        font-size: 2rem;
        font-weight: bold;
    }
    .stats-label {
        font-size: 0.9rem;
        opacity: 0.9;
    }
    .collapsible-properties {
        max-height: 150px;
        overflow-y: auto;
        transition: max-height 0.3s ease;
    }
    .expand-btn {
        cursor: pointer;
        color: #007bff;
        font-size: 0.85rem;
        margin-top: 5px;
    }
</style>
@endsection

@section('vendor-style')
<link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')}}">
<link rel="stylesheet" href="{{asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')}}">
<link rel="stylesheet" href="{{asset('assets/vendor/libs/flatpickr/flatpickr.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/libs/select2/select2.css')}}" />
@endsection

@section('vendor-script')
<script src="{{asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')}}"></script>
<script src="{{asset('assets/vendor/libs/select2/select2.js')}}"></script>
@endsection

@section('page-script')
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });

    // Toggle properties visibility
    $('.expand-properties').click(function() {
        const propertiesDiv = $(this).siblings('.collapsible-properties');
        propertiesDiv.toggleClass('expanded');
        if (propertiesDiv.hasClass('expanded')) {
            propertiesDiv.css('max-height', 'none');
            $(this).text('Show Less');
        } else {
            propertiesDiv.css('max-height', '150px');
            $(this).text('Show More');
        }
    });

    // Auto-submit on filter change
    $('.auto-submit').change(function() {
        $('#filterForm').submit();
    });

    // Clear individual filter
    $('.clear-filter').click(function() {
        const filterName = $(this).data('filter');
        $(`[name="${filterName}"]`).val('').trigger('change');
        $('#filterForm').submit();
    });

    // Clear all filters
    $('#clearAllFilters').click(function() {
        window.location.href = '{{ route('logs.index') }}';
    });

    // Export functionality
    $('#exportLogs').click(function() {
        const currentUrl = new URL(window.location.href);
        const exportUrl = '{{ route('logs.export') }}' + currentUrl.search;
        window.location.href = exportUrl;
    });

    // Live search with debounce
    let searchTimeout;
    $('#searchInput').on('keyup', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            $('#filterForm').submit();
        }, 500);
    });
});
</script>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="alert-body">
                    {{session('success')}}
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="stats-card">
                <div class="row">
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">{{ $activities->total() }}</div>
                        <div class="stats-label">Total Logs</div>
                    </div>
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">
                            {{ \Spatie\Activitylog\Models\Activity::whereDate('created_at', today())->count() }}
                        </div>
                        <div class="stats-label">Today's Logs</div>
                    </div>
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">
                            {{ \Spatie\Activitylog\Models\Activity::where('event', 'created')->whereDate('created_at', '>=', now()->subDays(7))->count() }}
                        </div>
                        <div class="stats-label">Created (7 Days)</div>
                    </div>
                    <div class="col-md-3 stats-item">
                        <div class="stats-number">
                            {{ \Spatie\Activitylog\Models\Activity::where('event', 'deleted')->whereDate('created_at', '>=', now()->subDays(7))->count() }}
                        </div>
                        <div class="stats-label">Deleted (7 Days)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="card-title mb-0">
                <i class="ti ti-file-analytics me-2"></i>@lang('word.SystemLogs')
            </h4>
            <div>
                <button class="btn btn-sm btn-outline-danger" id="clearAllFilters" type="button">
                    <i class="ti ti-filter-off me-1"></i>Clear All Filters
                </button>
                <button class="btn btn-sm btn-success" id="exportLogs" type="button">
                    <i class="ti ti-download me-1"></i>Export CSV
                </button>
            </div>
        </div>

        <div class="card-body">
            <!-- Active Filters Display -->
            @if($search || $event || $user_id || $subject_type || $date_filter || isset($startDate))
            <div class="mb-3">
                <strong>Active Filters:</strong>
                @if($search)
                    <span class="badge bg-info filter-badge">
                        Search: {{ $search }}
                        <span class="clear-filter" data-filter="search">×</span>
                    </span>
                @endif
                @if($event)
                    <span class="badge bg-warning filter-badge">
                        Event: {{ $event == 'created' ? 'Created' : ($event == 'updated' ? 'Updated' : 'Deleted') }}
                        <span class="clear-filter" data-filter="event">×</span>
                    </span>
                @endif
                @if($user_id)
                    <span class="badge bg-primary filter-badge">
                        User: {{ $users->find($user_id)->name ?? 'Not Found' }}
                        <span class="clear-filter" data-filter="user_id">×</span>
                    </span>
                @endif
                @if($subject_type)
                    <span class="badge bg-secondary filter-badge">
                        Type: {{ $subject_type }}
                        <span class="clear-filter" data-filter="subject_type">×</span>
                    </span>
                @endif
                @if($date_filter)
                    <span class="badge bg-success filter-badge">
                        Date: {{ 
                            $date_filter == 'today' ? 'Today' : 
                            ($date_filter == 'yesterday' ? 'Yesterday' : 
                            ($date_filter == 'last_7_days' ? 'Last 7 Days' : 
                            ($date_filter == 'last_30_days' ? 'Last 30 Days' : 
                            ($date_filter == 'this_month' ? 'This Month' : 'Last Month'))))
                        }}
                        <span class="clear-filter" data-filter="date_filter">×</span>
                    </span>
                @endif
                @if(isset($startDate))
                    <span class="badge bg-success filter-badge">
                        Date Range: {{ $startDate }} to {{ $endDate ?? '' }}
                    </span>
                @endif
            </div>
            @endif

            <!-- Filter Section -->
            <div class="filter-card">
                <form action="{{ route('logs.index') }}" method="GET" id="filterForm">
                    <!-- Quick Date Filters -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label fw-bold">Quick Date Filter:</label>
                            <div class="btn-group" role="group">
                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="today" id="today" {{ $date_filter == 'today' ? 'checked' : '' }}>
                                <label class="btn btn-outline-primary btn-sm" for="today">Today</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="yesterday" id="yesterday" {{ $date_filter == 'yesterday' ? 'checked' : '' }}>
                                <label class="btn btn-outline-primary btn-sm" for="yesterday">Yesterday</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="last_7_days" id="last_7_days" {{ $date_filter == 'last_7_days' ? 'checked' : '' }}>
                                <label class="btn btn-outline-primary btn-sm" for="last_7_days">Last 7 Days</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="last_30_days" id="last_30_days" {{ $date_filter == 'last_30_days' ? 'checked' : '' }}>
                                <label class="btn btn-outline-primary btn-sm" for="last_30_days">Last 30 Days</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="this_month" id="this_month" {{ $date_filter == 'this_month' ? 'checked' : '' }}>
                                <label class="btn btn-outline-primary btn-sm" for="this_month">This Month</label>

                                <input type="radio" class="btn-check auto-submit" name="date_filter" value="last_month" id="last_month" {{ $date_filter == 'last_month' ? 'checked' : '' }}>
                                <label class="btn btn-outline-primary btn-sm" for="last_month">Last Month</label>
                            </div>
                        </div>
                    </div>

                    <!-- Advanced Filters -->
                    <div class="row">
                        <div class="col-md-3">
                            <label for="searchInput" class="form-label">Search</label>
                            <input type="text" class="form-control" id="searchInput" name="search" 
                                   value="{{ $search ?? '' }}" 
                                   placeholder="Search in logs...">
                        </div>

                        <div class="col-md-2">
                            <label for="event" class="form-label">Event Type</label>
                            <select name="event" id="event" class="form-select auto-submit">
                                <option value="">All Events</option>
                                <option value="created" {{ $event == 'created' ? 'selected' : '' }}>Created</option>
                                <option value="updated" {{ $event == 'updated' ? 'selected' : '' }}>Updated</option>
                                <option value="deleted" {{ $event == 'deleted' ? 'selected' : '' }}>Deleted</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="user_id" class="form-label">User</label>
                            <select name="user_id" id="user_id" class="form-select select2 auto-submit">
                                <option value="">All Users</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ $user_id == $user->id ? 'selected' : '' }}>
                                        {{ $user->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="subject_type" class="form-label">Model Type</label>
                            <select name="subject_type" id="subject_type" class="form-select select2 auto-submit">
                                <option value="">All Types</option>
                                @foreach($modelTypes as $type)
                                    <option value="{{ $type }}" {{ $subject_type == $type ? 'selected' : '' }}>
                                        {{ $type }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="per_page" class="form-label">Per Page</label>
                            <select name="per_page" id="per_page" class="form-select auto-submit">
                                <option value="25" {{ $per_page == 25 ? 'selected' : '' }}>25</option>
                                <option value="50" {{ $per_page == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ $per_page == 100 ? 'selected' : '' }}>100</option>
                                <option value="200" {{ $per_page == 200 ? 'selected' : '' }}>200</option>
                            </select>
                        </div>
                    </div>
                </form>

                <!-- Custom Date Range Form -->
                <form action="{{ route('logs.search') }}" method="POST" class="mt-3">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <label for="start_date" class="form-label">Date Range - From:</label>
                            <input class="form-control" type="date" value="{{ $startDate ?? '' }}" 
                                   id="start_date" name="start_date">
                        </div>
                        <div class="col-md-4">
                            <label for="end_date" class="form-label">To:</label>
                            <input class="form-control" type="date" value="{{ $endDate ?? '' }}" 
                                   id="end_date" name="end_date">
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit">
                                <i class="ti ti-search me-1"></i>Search
                            </button>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <a href="{{ route('logs.index') }}" class="btn btn-outline-secondary w-100">
                                <i class="ti ti-refresh me-1"></i>Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Results Info -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    Showing <strong>{{ $activities->firstItem() }}</strong> to 
                    <strong>{{ $activities->lastItem() }}</strong> of 
                    <strong>{{ $activities->total() }}</strong> results
                </div>
            </div>

            <!-- Logs Table -->
            <div class="table-responsive">
                <table class="table table-hover" id="logsTable">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 60px;">#</th>
                            <th style="width: 120px;">Type</th>
                            <th style="width: 100px;">Event</th>
                            <th>Description</th>
                            <th style="width: 35%;">Properties</th>
                            <th style="width: 120px;">User</th>
                            <th style="width: 150px;">Date & Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($activities as $activity)
                            <tr class="log-row">
                                <td>
                                    <span class="badge bg-label-secondary">{{ $activity->id }}</span>
                                </td>
                                <td>
                                    <span class="badge bg-label-info">
                                        {{ substr($activity->subject_type, strrpos($activity->subject_type, "\\") + 1) }}
                                    </span>
                                </td>
                                <td>
                                    @switch($activity->event)
                                        @case('created')
                                            <span class="badge bg-success badge-custom">
                                                <i class="ti ti-plus me-1"></i>Created
                                            </span>
                                            @break
                                        @case('updated')
                                            <span class="badge bg-warning badge-custom">
                                                <i class="ti ti-pencil me-1"></i>Updated
                                            </span>
                                            @break
                                        @case('deleted')
                                            <span class="badge bg-danger badge-custom">
                                                <i class="ti ti-trash me-1"></i>Deleted
                                            </span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary badge-custom">
                                                {{ ucfirst($activity->event) }}
                                            </span>
                                    @endswitch
                                </td>
                                <td>
                                    <div class="text-truncate" style="max-width: 200px;" title="{{ $activity->description }}">
                                        {!! $activity->description ?? '<span class="text-muted">-</span>' !!}
                                    </div>
                                </td>
                                <td>
                                    <div class="properties-section">
                                        @if($activity->event == 'updated')
                                            <div class="collapsible-properties">
                                                <strong><span class="badge bg-secondary mb-1">Old Data</span></strong>
                                                <ul class="mb-2">
                                                    @foreach($activity->properties['old'] ?? [] as $index => $value)
                                                        @if(!is_array($value))
                                                            <li><strong>{{ $index }}:</strong> {{ $value ?? '-' }}</li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                                <strong><span class="badge bg-success mb-1">New Data</span></strong>
                                                <ul>
                                                    @foreach($activity->properties['attributes'] ?? [] as $index => $value)
                                                        @if(!is_array($value))
                                                            <li><strong>{{ $index }}:</strong> {{ $value ?? '-' }}</li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @if(count($activity->properties['old'] ?? []) > 3)
                                                <div class="expand-btn expand-properties">Show More</div>
                                            @endif
                                        @elseif($activity->event == 'created')
                                            <div class="collapsible-properties">
                                                <ul>
                                                    @foreach($activity->properties['attributes'] ?? [] as $index => $value)
                                                        @if(!is_array($value))
                                                            <li><strong>{{ $index }}:</strong> {{ $value ?? '-' }}</li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                            @if(count($activity->properties['attributes'] ?? []) > 3)
                                                <div class="expand-btn expand-properties">Show More</div>
                                            @endif
                                        @else
                                            <div class="collapsible-properties">
                                                <ul>
                                                    @foreach($activity->properties['old'] ?? [] as $index => $value)
                                                        @if(!is_array($value))
                                                            <li><strong>{{ $index }}:</strong> {{ $value ?? '-' }}</li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    @if($activity->causer)
                                        <div class="d-flex align-items-center">
                                            <div class="avatar avatar-sm me-2">
                                                <span class="avatar-initial rounded-circle bg-label-primary">
                                                    {{ substr($activity->causer->name, 0, 2) }}
                                                </span>
                                            </div>
                                            <div>
                                                <small class="fw-semibold">{{ $activity->causer->name }}</small>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-muted">System</span>
                                    @endif
                                </td>
                                <td>
                                    <div>
                                        <i class="ti ti-calendar me-1"></i>
                                        <small>{{ $activity->created_at->format('Y-m-d') }}</small>
                                    </div>
                                    <div>
                                        <i class="ti ti-clock me-1"></i>
                                        <small>{{ $activity->created_at->format('h:i A') }}</small>
                                    </div>
                                    <small class="text-muted">{{ $activity->created_at->diffForHumans() }}</small>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="mb-3">
                                        <i class="ti ti-folder-off" style="font-size: 3rem; color: #ccc;"></i>
                                    </div>
                                    <h5 class="text-muted">No Records Found</h5>
                                    <p class="text-muted">Please change the filters or search criteria</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-3">
                <div>
                    Showing <strong>{{ $activities->firstItem() }}</strong> to 
                    <strong>{{ $activities->lastItem() }}</strong> of 
                    <strong>{{ $activities->total() }}</strong> results
                </div>
                <div>
                    {{ $activities->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
