<!DOCTYPE html>
<html>
<header>
    <!-- Preload the font -->
    <link rel="preload" href="{{ asset('fonts/NRT-Bd.ttf') }}" as="font" type="font/ttf" crossorigin="anonymous">

    <style type="text/css">
        @font-face {
            font-family: 'rudawregular2';
            src: url('{{ asset('fonts/NRT-Bd.ttf') }}') format('truetype');
            font-display: swap;
        }
    </style>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        /* General styles for the invoice */
        @page {
            size: A4 portrait;
            margin: 0;
        }

        body {
            font-family: 'rudawregular2', sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
        }

        .invoice-container {
            width: 100%;
            max-height: 100%;
            padding: 10px;
            box-sizing: border-box;
            page-break-after: avoid;
        }

        .invoice-copy {
            padding: 15px;
            border: 1px solid #ccc;
            margin-bottom: 10px;
            position: relative;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 2px solid #2c3e50;
            padding-bottom: 10px;
        }

        .logo {
            width: 120px;
            height: auto;
            margin: 0 auto;
        }

        .header h1 {
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .transaction-info {
            display: flex;
            justify-content: space-between;
            margin: 10px 0;
        }

        .invoice-type-box {
            background-color: #3498db;
            color: white;
            padding: 5px 15px;
            font-weight: bold;
            text-align: center;
            border-radius: 4px;
        }

        .invoice-info {
            text-align: left;
            color: #7f8c8d;
        }

        .info-row {
            margin: 10px 0;
        }

        .name-row {
            display: flex;
            margin: 15px 0;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }

        .name-column {
            flex: 0 0 50%;
        }

        .name-label {
            color: #3498db;
            font-weight: bold;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .name-value {
            border-bottom: 1px dotted #ccc;
            padding-bottom: 3px;
            font-size: 16px;
        }

        .amount-section {
            margin: 15px 0;
        }

        .amount-row {
            display: flex;
            align-items: center;
            margin: 10px 0;
        }

        .amount-label {
            width: 120px;
            font-weight: bold;
            color: #3498db;
        }

        .amount-value {
            flex: 1;
            border-bottom: 1px dotted #ccc;
            padding: 0 0 3px 0;
            text-align: right;
            font-weight: bold;
            color: #2c3e50;
        }

        .amount-in-words {
            color: #7f8c8d;
            font-style: italic;
            margin-left: 20px;
        }

        .note-row {
            margin: 15px 0;
        }

        .note-label {
            font-weight: bold;
            color: #3498db;
            margin-bottom: 5px;
        }

        .note-value {
            border-bottom: 1px dotted #ccc;
            padding-bottom: 3px;
        }

        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        .signature-box {
            text-align: center;
            width: 30%;
        }

        .signature-title {
            font-size: 12px;
            color: #7f8c8d;
            margin-bottom: 25px;
        }

        .signature-line {
            border-top: 1px solid #333;
            width: 100%;
        }

        .dotted-separator {
            border: none;
            border-top: 2px dashed #bdc3c7;
            margin: 5px 0;
        }

        #printButton {
            position: fixed;
            top: 20px;
            right: 20px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 8px 15px;
            font-size: 14px;
            cursor: pointer;
            z-index: 1000;
        }

        #printButton:hover {
            background-color: #2980b9;
        }

        .attached-image {
            height: 60px; 
            width: 120px; 
            border: 1px solid #ccc; 
            border-radius: 4px;
            object-fit: contain;
        }

        .contact-info {
            direction: ltr;
            unicode-bidi: embed;
            text-align: left;
            display: inline-block;
        }

        @media print {
            #printButton {
                display: none;
            }
            
            body {
                width: 210mm;
                height: 297mm;
                margin: 0;
                padding: 0;
            }
            
            .invoice-container {
                width: 100%;
                height: 100%;
                page-break-inside: avoid;
                page-break-after: avoid;
            }
            
            .invoice-copy {
                border: none;
                page-break-inside: avoid;
            }
            
            .dotted-separator {
                border-top: 2px dashed #000;
                margin: 10px 0;
            }
        }
    </style>
</header>

<body dir="rtl">
<!-- Print Button -->
<button id="printButton" onclick="printInvoice()">Print Invoice</button>

<div class="invoice-container">
    <!-- First Copy -->
    <div class="invoice-copy">
        <div class="header">
            <div class="row">
                <div class="col-4">
                    <h1>الامان</h1>
                    <p>بۆ ئاڵوگۆڕی دراو</p>
                    <p>هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى</p>
                </div>
                <div class="col-4">
                    <img src="/assets/logoback.png" alt="BATWAN Logo" class="logo">
                </div>
                <div class="col-4">
                    <h1>al-aman</h1>
                    <p>al-aman for Clinic</p>
                    <p class="contact-info">Mobile - 0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173</p>
                </div>
            </div>
        </div>

        <div class="transaction-info">
            <div class="invoice-type">
                <div class="invoice-type-box">
                    @if($select_transaction->transaction_type == 'deposit')
                    {{ __('word.Deposit') }}
                    @elseif($select_transaction->transaction_type == 'withdrawal')
                    {{ __('word.Withdrawal') }}
                    @elseif($select_transaction->transaction_type == 'transfer')
                    {{ __('word.Transfer') }}
                    @endif
                </div>
            </div>
            <div class="invoice-info">
                <strong>Invoice No:</strong> {{$select_transaction->id}}
                <br>
                <strong>Date:</strong> {{$select_transaction->transaction_date->format('Y-m-d')}}
            </div>
        </div>

        <div class="name-row">
            <div class="name-column">
                <div class="name-label">{{ __('word.SenderName') }}:</div>
                <div dir="rtl" class="name-value">{{$select_transaction->sender_name}}</div>
            </div>
            <div class="name-column">
                <div class="name-label">{{ __('word.ReceiverName') }}:</div>
                <div dir="rtl" class="name-value">{{$select_transaction->receiver_name}}</div>
            </div>
        </div>
        
        <div class="amount-section">
            <div class="amount-row">
                <div class="amount-label">{{ __('word.Amount') }}:</div>
                <div class="amount-value">{{number_format($select_transaction->transaction_amount, 0, '.', ',')}} ({{ $select_transaction->from_account->currency->currency_name }})  {{convertNumberToWordsKurdishSorani($select_transaction->transaction_amount)}} </div>
            </div>
            
            @if(isset($select_transaction->fee) && $select_transaction->fee > 0)
            <div class="amount-row">
                <div class="amount-label">{{ __('word.Fee') }}:</div>
                <div class="amount-value">{{number_format($select_transaction->fee, 0, '.', ',')}} ({{ $select_transaction->from_account->currency->currency_name }})</div>
            </div>
            @endif
        </div>
        
        <div class="note-row">
            <div class="note-label">@lang('word.Note'):</div>
            <div class="note-value">
                @if($select_transaction->transaction_type == 'deposit')
                @lang('word.NoteUpdate') ({{$select_transaction->sender_name ?? '-' }}) - {{$select_transaction->note}}
                @elseif($select_transaction->transaction_type == 'withdrawal')
                @lang('word.NoteUpdate1') ({{$select_transaction->sender_name}}) @lang('word.NoteUpdate2') ({{$select_transaction->receiver_name}}) - {{$select_transaction->note}}
                @endif
            </div>
        </div>

        <div class="signatures">
            <div class="signature-box">
                <p class="signature-title">ئیمزای وەرگر</p>
                <div class="signature-line"></div>
            </div>
            <div class="signature-box">
                <!-- Display Attached Images Section -->
                @if ($select_transaction->files->isEmpty())
                <!-- No files to display -->
                @else
                    <div style="text-align: center;">
                        @php
                            $lastFile = $select_transaction->files->last();
                        @endphp
                        <img src="{{ asset('storage/' . $lastFile->file_path) }}" alt="Attached Image" class="attached-image">
                    </div>
                @endif
            </div>
            <div class="signature-box">
                <p class="signature-title">ئیمزای پێدەر</p>
                <div class="signature-line"></div>
            </div>
        </div>
    </div>

    <!-- Dotted line separator -->
    <hr class="dotted-separator">

    <!-- Second Copy (Duplicate) -->
    <div class="invoice-copy">
        <div class="header">
            <div class="row">
                <div class="col-4">
                    <h1>الامان</h1>
                    <p>بۆ ئاڵوگۆڕی دراو</p>
                    <p>هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى</p>
                </div>
                <div class="col-4">
                    <img src="/assets/logoback.png" alt="BATWAN Logo" class="logo">
                </div>
                <div class="col-4">
                    <h1>al-aman</h1>
                    <p>al-aman for Clinic</p>
                    <p class="contact-info">Mobile - 0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173</p>
                </div>
            </div>
        </div>

        <div class="transaction-info">
            <div class="invoice-type">
                <div class="invoice-type-box">
                    @if($select_transaction->transaction_type == 'deposit')
                    {{ __('word.Deposit') }}
                    @elseif($select_transaction->transaction_type == 'withdrawal')
                    {{ __('word.Withdrawal') }}
                    @elseif($select_transaction->transaction_type == 'transfer')
                    {{ __('word.Transfer') }}
                    @endif
                </div>
            </div>
            <div class="invoice-info">
                <strong>Invoice No:</strong> {{$select_transaction->id}}
                <br>
                <strong>Date:</strong> {{$select_transaction->transaction_date->format('Y-m-d')}}
            </div>
        </div>

        <div class="name-row">
            <div class="name-column">
                <div class="name-label">{{ __('word.SenderName') }}:</div>
                <div dir="rtl" class="name-value">{{$select_transaction->sender_name}}</div>
            </div>
            <div class="name-column">
                <div class="name-label">{{ __('word.ReceiverName') }}:</div>
                <div dir="rtl" class="name-value">{{$select_transaction->receiver_name}}</div>
            </div>
        </div>
        
        <div class="amount-section">
            <div class="amount-row">
                <div class="amount-label">{{ __('word.Amount') }}:</div>
                <div class="amount-value">{{number_format($select_transaction->transaction_amount, 0, '.', ',')}} ({{ $select_transaction->from_account->currency->currency_name }})  {{convertNumberToWordsKurdishSorani($select_transaction->transaction_amount)}}</div>
            </div>
        
            
            @if(isset($select_transaction->fee) && $select_transaction->fee > 0)
            <div class="amount-row">
                <div class="amount-label">{{ __('word.Fee') }}:</div>
                <div class="amount-value">{{number_format($select_transaction->fee, 0, '.', ',')}} ({{ $select_transaction->from_account->currency->currency_name }})</div>
            </div>
            @endif
        </div>
        
        <div class="note-row">
            <div class="note-label">@lang('word.Note'):</div>
            <div class="note-value">
                @if($select_transaction->transaction_type == 'deposit')
                @lang('word.NoteUpdate') ({{$select_transaction->sender_name ?? '-' }}) - {{$select_transaction->note}}
                @elseif($select_transaction->transaction_type == 'withdrawal')
                @lang('word.NoteUpdate1') ({{$select_transaction->sender_name}}) @lang('word.NoteUpdate2') ({{$select_transaction->receiver_name}}) - {{$select_transaction->note}}
                @endif
            </div>
        </div>

        <div class="signatures">
            <div class="signature-box">
                <p class="signature-title">ئیمزای وەرگر</p>
                <div class="signature-line"></div>
            </div>
            <div class="signature-box">
                <!-- Display Attached Images Section -->
                @if ($select_transaction->files->isEmpty())
                <!-- No files to display -->
                @else
                    <div style="text-align: center;">
                        @php
                            $lastFile = $select_transaction->files->last();
                        @endphp
                        <img src="{{ asset('storage/' . $lastFile->file_path) }}" alt="Attached Image" class="attached-image">
                    </div>
                @endif
            </div>
            <div class="signature-box">
                <p class="signature-title">ئیمزای پێدەر</p>
                <div class="signature-line"></div>
            </div>
        </div>
    </div>
</div>

<script>
    function printInvoice() {
        window.print();
    }
</script>
</body>
</html>