@php $editing = isset($customer) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="customer_name"
            label="Customer Name"
            :value="old('customer_name', ($editing ? $customer->customer_name : ''))"
            maxlength="255"
            placeholder="Customer Name"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="phone_number"
            label="Phone Number"
            :value="old('phone_number', ($editing ? $customer->phone_number : ''))"
            maxlength="255"
            placeholder="Phone Number"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="second_phone"
            label="Second Phone"
            :value="old('second_phone', ($editing ? $customer->second_phone : ''))"
            maxlength="255"
            placeholder="Second Phone"
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="address"
            label="Address"
            :value="old('address', ($editing ? $customer->address : ''))"
            maxlength="255"
            placeholder="Address"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.textarea name="note" label="Note" maxlength="255" required
            >{{ old('note', ($editing ? $customer->note : ''))
            }}</x-inputs.textarea
        >
    </x-inputs.group>
</div>
