@extends('layouts/layoutMaster')

@section('title', 'Update customers')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('customers.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.customers.edit_title')
            </h4>

            <x-form
                method="PUT"
                action="{{ route('customers.update', $customer) }}"
                class="mt-4"
            >
                @include('app.customers.form-inputs')

                <div class="mt-4">
                    <a
                        href="{{ route('customers.index') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-return-left text-primary"></i>
                        @lang('crud.common.back')
                    </a>

                    <a
                        href="{{ route('customers.create') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-add text-primary"></i>
                        @lang('crud.common.create')
                    </a>

                    <button type="submit" class="btn btn-primary float-right">
                        <i class="icon ion-md-save"></i>
                        @lang('crud.common.update')
                    </button>
                </div>
            </x-form>
        </div>
    </div>

    @can('view-any', App\Models\Account::class)
    <div class="card mt-4">
        <div class="card-body">
            <h4 class="card-title w-100 mb-2">Accounts</h4>

            <livewire:customer-accounts-detail :customer="$customer" />
        </div>
    </div>
    @endcan
@endsection
