<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Account Balance</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">
    <style>
        @font-face {
            font-family: 'rudawregular2';
            src: url('{{ asset('fonts/NRT-Bd.ttf') }}') format('truetype');
            font-display: swap;
        }
        
        body {
            font-family: 'rudawregular2', sans-serif;
            background-color: #f0f4f8;
            color: #333;
        }
        
        .dashboard-container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 25px;
            background-color: #ffffff;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .dashboard-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .branding {
            display: flex;
            align-items: center;
        }
        
        .logo-container {
            width: 130px;
            height: 130px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-right: 20px;
            border-radius: 15px;
            background-color: #e7ebef;
            padding: 10px;
        }
        
        .logo {
            max-width: 200px;
            max-height: 200px;
        }
        
        .company-title {
            color: #2c3e50;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .customer-info {
            background: linear-gradient(135deg, #ff9966 0%, #ff5e62 100%);
            border-radius: 15px;
            padding: 20px;
            color: white;
            max-width: 350px;
            width: 100%;
            box-shadow: 0 8px 16px rgba(255, 94, 98, 0.2);
        }
        
        .customer-name {
            font-size: 35px;
            font-weight: bold;
            margin-bottom: 5px;
            display: flex;
            align-items: center;
        }
        
        .customer-name i {
            margin-right: 10px;
            font-size: 24px;
        }
        
        .customer-id {
            font-size: 26px;
            opacity: 0.9;
            margin-bottom: 10px;
        }
        
        .timestamp {
            font-size: 20px;
            opacity: 0.8;
            text-align: right;
        }
        
        .accounts-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .account-card {
            background-color: #ffffff;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .account-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }
        
        .account-balance {
            padding: 25px 20px;
            text-align: center;
            color: white;
        }
        
        .balance-positive {
            background: linear-gradient(135deg, #21D4FD 0%, #2152FF 100%);
        }
        
        .balance-negative {
            background: linear-gradient(135deg, #FF416C 0%, #FF4B2B 100%);
        }
        
        .balance-zero {
            background: linear-gradient(135deg, #8E9EAB 0%, #eef2f3 100%);
            color: #333;
        }
        
        .balance-amount {
            font-size: 32px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .balance-label {
            font-size: 18px;
            margin-bottom: 10px;
        }
        
        .currency-name {
            font-size: 20px;
            opacity: 0.9;
            font-weight: 500;
        }
        
        .transactions-section {
            background-color: #f8f9fa;
            padding: 15px;
        }
        
        .transactions-header {
            background-color: #364f6b;
            color: white;
            text-align: center;
            padding: 10px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 8px;
            margin-bottom: 15px;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        }
        
        .transactions-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.05);
        }
        
        .transactions-table th {
            background-color: #f1f1f1;
            color: #333;
            text-align: center;
            padding: 12px 8px;
            font-weight: 600;
            font-size: 14px;
        }
        
        .transactions-table td {
            padding: 10px 8px;
            text-align: center;
            border-top: 1px solid #f1f1f1;
            font-size: 14px;
        }
        
        .transactions-table tr:hover {
            background-color: #f9f9f9;
        }
        
        .amount-positive {
            color: #00b894;
            font-weight: 600;
        }
        
        .amount-negative {
            color: #d63031;
            font-weight: 600;
        }
        
        .transaction-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            color: white;
        }
        
        .badge-deposit {
            background-color: #00b894;
        }
        
        .badge-withdrawal {
            background-color: #d63031;
        }
        
        .badge-transfer {
            background-color: #0984e3;
        }
        
        .no-transactions {
            text-align: center;
            padding: 20px;
            color: #6c757d;
            font-style: italic;
        }
        
        .footer {
            text-align: center;
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
        }
        
        .footer-message {
            font-size: 18px;
            color: #555;
            margin-bottom: 15px;
        }
        
        .contact-info {
            font-size: 16px;
            color: #0984e3;
            margin-bottom: 30px;
            direction: ltr;
            unicode-bidi: embed;
            text-align: left;
            display: inline-block;
        }
        
        .contact-info i {
            margin-right: 5px;
        }
        
        .action-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
        }
        
        .btn-action {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 12px 25px;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-download {
            background-color: #0984e3;
            color: white;
        }
        
        .btn-download:hover {
            background-color: #0876c9;
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(9, 132, 227, 0.2);
        }
        
        .btn-share {
            background-color: #25D366;
            color: white;
        }
        
        .btn-share:hover {
            background-color: #20bd5c;
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(37, 211, 102, 0.2);
        }
        
        .btn-action i {
            margin-right: 10px;
            font-size: 18px;
        }
        
        .download-border {
            border: 3px solid #0984e3;
            box-shadow: 0 0 20px rgba(9, 132, 227, 0.3);
        }
        
        @media (max-width: 992px) {
            .dashboard-header {
                flex-direction: column;
                align-items: center;
                text-align: center;
            }
            
            .branding {
                margin-bottom: 20px;
            }
            
            .customer-info {
                max-width: 100%;
            }
            
            .accounts-container {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            }
        }
        
        @media (max-width: 576px) {
            .dashboard-header {
                padding-bottom: 15px;
                margin-bottom: 20px;
            }
            
            .branding {
                flex-direction: column;
                text-align: center;
            }
            
            .logo-container {
                margin-right: 0;
                margin-bottom: 15px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn-action {
                width: 100%;
            }
        }
    </style>
</head>
<body>

<div class="dashboard-container" id="dashboard-container">
    <!-- Header Section with Logo and Customer Info -->
    <div class="dashboard-header">
        <div class="branding">
            <div class="logo-container">
                <img src="/assets/logoback.png" alt="Logo" class="logo">
            </div>
            <div>
                <h2 class="company-title" dir="auto">مکتب الامان</h2>
                <h3 class="text-muted" dir="auto">مطابقة الارصدة</h3>
            </div>
        </div>
        
        <div class="customer-info" id="customer-card">
            <div class="customer-name" dir="auto">
                <i class="fas fa-user-circle"></i>
                {{ $customer->customer_name ?? 'Unknown Customer' }}
            </div>
            <div class="customer-id" dir="auto">ID: {{ $customer->id ?? 'N/A' }}</div>
            <div class="timestamp" dir="auto">{{ now()->format('Y-m-d H:i:s') }}</div>
        </div>
    </div>

    <!-- Accounts Section -->
    <div class="accounts-container">
        @foreach ($customer->accounts as $account)
        <div class="account-card">
            <a href="{{ route('check-balance', $account) }}" style="text-decoration: none; color: inherit;">
                <div class="account-balance 
                    @if ($account->calculateTotalBalance() > 0)
                        balance-positive
                    @elseif ($account->calculateTotalBalance() < 0)
                        balance-negative
                    @else
                        balance-zero
                    @endif
                ">
                    <div class="balance-amount">
                        {{ number_format($account->calculateTotalBalance(), 0, '.', ',') }}
                    </div>
                    
                    <div class="balance-label">
                        @if ($account->calculateTotalBalance() > 0)
                            لامانە
                        @elseif($account->calculateTotalBalance() == 0)
                            -
                        @else
                            لاتانە
                        @endif
                    </div>
                    
                    <div class="currency-name" dir="auto">{{ $account->currency->currency_name }}</div>
                </div>
            </a>
            
            <div class="transactions-section">
                <div class="transactions-header">
                    کۆتا ٥ جوولە
                </div>
                
                <table class="transactions-table">
                    <thead>
                        <tr>
                            <th>@lang('word.Date')</th>
                            <th>@lang('word.TransactionAmount')</th>
                            <th>@lang('word.TransactionType')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $lastTransactions = $account->pendingTransactions()
                            ->where('status', '!=', 'rejected') // Exclude rejected transactions
                            ->orderBy('created_at', 'desc')
                            ->take(5)
                            ->get();
                        @endphp

                        @forelse($lastTransactions as $value)
                            @if ($value->transaction_type == 'fee')
                                @continue
                            @endif
                        
                            @if ($value->to_account_id == $account->id)
                                @continue
                            @endif
                        
                            @if ($value->from_account->customer->id == 1)
                                @continue
                            @endif

                            <tr>
                                <td>{{ $value->created_at->format('Y-m-d') ?? '-' }}</td>
                                <td>
                                    @php
                                        $isWithdrawal = $value->transaction_type == 'withdrawal';
                                        $amount = $isWithdrawal ? -$value->transaction_amount : $value->transaction_amount;
                                        $amountClass = $isWithdrawal ? 'amount-negative' : 'amount-positive';
                                    @endphp
                                    <span class="{{ $amountClass }}">
                                        {{ number_format($amount, 0, '.', ',') ?? '-' }} 
                                    </span>
                                </td>                                           
                            
                                <td>
                                    @if($value->transaction_type == 'deposit')
                                        <span class="transaction-badge badge-deposit">{{ __('word.Deposit') }}</span>
                                    @elseif($value->transaction_type == 'withdrawal')
                                        <span class="transaction-badge badge-withdrawal">{{ __('word.Withdrawal') }}</span>
                                    @elseif($value->transaction_type == 'transfer')
                                        <span class="transaction-badge badge-transfer">{{ __('word.Transfer') }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="no-transactions">هیچ جوولەیەک بەردەست نیە</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @endforeach
    </div>
    
    <!-- Footer Section -->
    <div class="footer">
        <div class="footer-message" dir="auto">
            تکایە ئاگادارمان بکەوە ئەگەر پێت وایە کێشەیەک هەیە
        </div>
        <div class="contact-info" dir="auto">
            <i class="fas fa-phone-alt"></i>  0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173
        </div>

        <!-- Download and Share Buttons -->
        <div class="action-buttons" id="download-btn">
            <button class="btn-action btn-download" id="download-image">
                <i class="fas fa-download"></i> دابەزاندن
            </button>
            <button class="btn-action btn-share" id="share-whatsapp">
                <i class="fas fa-share"></i> هاوبەشکردن لە وەتسئەپ
            </button>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<meta name="csrf-token" content="{{ csrf_token() }}">

<script>
    document.getElementById('share-whatsapp').addEventListener('click', function () {
        const customerPhone = "964{{ $customer->phone_number ?? '' }}";
        if (!customerPhone) {
            alert('ژمارەی مۆبایلەکە هەڵەیە!');
            return;
        }

        const shareButton = document.getElementById('share-whatsapp');
        const downloadButton = document.getElementById('download-btn');
        shareButton.disabled = true;

        const customerCard = document.getElementById('customer-card');
        customerCard.classList.add('download-border');

        downloadButton.style.display = 'none';

        const contentToCapture = document.getElementById('dashboard-container');

        setTimeout(function() {
            html2canvas(contentToCapture, { scale: 2 }).then(function (canvas) {
                const imageData = canvas.toDataURL('image/png');

                fetch('/upload-image', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ image: imageData })
                })
                .then(response => response.json())
                .then(data => {
                    const customerName = "{{ $customer->customer_name ?? 'Unknown Customer' }}";
                    const whatsappUrl = `https://wa.me/${customerPhone}?text=${encodeURIComponent('سڵاو ' + customerName + '، ئەم لینکە بکەوە بۆ کەشف حسابت\n') + data.image_url}`;
                    window.open(whatsappUrl, '_blank');

                    downloadButton.style.display = 'flex';
                    shareButton.disabled = false;
                    customerCard.classList.remove('download-border');
                })
                .catch(error => {
                    alert('Error uploading image');
                    console.error(error);

                    downloadButton.style.display = 'flex';
                    shareButton.disabled = false;
                    customerCard.classList.remove('download-border');
                });
            });
        }, 100);
    });
</script>

<script>
    document.getElementById('download-image').addEventListener('click', function () {
        const downloadButton = document.getElementById('download-btn');
        downloadButton.style.display = 'none';

        const customerCard = document.getElementById('customer-card');
        customerCard.classList.add('download-border');

        const contentToCapture = document.getElementById('dashboard-container');

        setTimeout(function() {
            html2canvas(contentToCapture, { scale: 2 }).then(function (canvas) {
                const link = document.createElement('a');
                link.download = 'customer_accounts.png';
                link.href = canvas.toDataURL('image/png');
                link.click();

                downloadButton.style.display = 'flex';
                customerCard.classList.remove('download-border');
            });
        }, 100);
    });
</script>

</body>
</html>