@extends('layouts/layoutMaster')

@section('title', 'Show currencies')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('currencies.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.currencies.show_title')
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>@lang('crud.currencies.inputs.currency_name')</h5>
                    <span>{{ $currency->currency_name ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.currencies.inputs.code')</h5>
                    <span>{{ $currency->code ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.currencies.inputs.rate')</h5>
                    <span>{{ $currency->rate ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a href="{{ route('currencies.index') }}" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    @lang('crud.common.back')
                </a>

                @can('create', App\Models\Currency::class)
                <a
                    href="{{ route('currencies.create') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection
