<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نرخی دراوەکان | Currency Exchange Rates | al-aman | هەولێر</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="Live currency exchange rates in Hawler (Erbil), Iraq. Real-time USD, Euro, Pound, Turkish Lira, UAE Dirham, Saudi Riyal, Australian Dollar, Canadian Dollar rates. Best exchange rates in Kurdistan.">
    <meta name="keywords" content="currency exchange, exchange rates, USD, Euro, Pound, Turkish Lira, UAE Dirham, Saudi Riyal, Australian Dollar, Canadian Dollar, Hawler, Erbil, Iraq, Kurdistan, cash exchange, Clinic">
    <meta name="author" content="al-aman">
    <meta name="robots" content="index, follow">
    <meta name="language" content="en, ku, ar">
    
    <!-- Open Graph Meta Tags for Social Media -->
    <meta property="og:title" content="Live Currency Exchange Rates | al-aman">
    <meta property="og:description" content="Real-time currency exchange rates in Hawler, Iraq. USD, Euro, Pound, Turkish Lira, UAE Dirham and more. Best rates in Kurdistan.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:site_name" content="al-aman">
    <meta property="og:locale" content="en_US">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Live Currency Exchange Rates | al-aman">
    <meta name="twitter:description" content="Real-time currency exchange rates in Hawler, Iraq. Best rates for USD, Euro, Pound, Turkish Lira, UAE Dirham and more.">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="{{ url()->current() }}">
    
    <!-- Additional SEO Meta Tags -->
    <meta name="geo.region" content="IQ-AR">
    <meta name="geo.placename" content="Hawler, Erbil, Iraq">
    <meta name="geo.position" content="36.1901;43.9930">
    <meta name="ICBM" content="36.1901, 43.9930">
    
    <!-- Schema.org Structured Data for Currency Exchange -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "FinancialService",
        "name": "al-aman",
        "description": "Professional currency exchange service in Hawler, Iraq offering real-time rates for major world currencies",
        "url": "{{ url()->current() }}",
        "telephone": "0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "شەقامی برایەتی بەرامبەر مزگەوتی شێخ محی الدین",
            "addressLocality": "Hawler",
            "addressRegion": "Erbil",
            "addressCountry": "IQ"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": 36.1901,
            "longitude": 43.9930
        },
        "openingHours": "Mo-Su 09:00-18:00",
        "priceRange": "$$",
        "currenciesAccepted": ["USD", "EUR", "GBP", "TRY", "IRR", "AED", "JOD", "SEK", "NOK", "CHF", "SAR", "AUD", "CAD"],
        "paymentAccepted": ["Cash", "Bank Transfer"],
        "areaServed": "Hawler, Erbil, Iraq, Kurdistan"
    }
    </script>
    
    <!-- Sitemap and Additional SEO -->
    <link rel="sitemap" type="application/xml" title="Sitemap" href="/sitemap.xml">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Tailwind Config for RTL support -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Segoe UI', 'Tahoma', 'Geneva', 'Verdana', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    
    @livewireStyles
</head>
<body class="bg-gray-50" dir="rtl">
    
    <!-- SEO-Friendly Header Section -->
    <header class="bg-white shadow-sm border-b" style="display: none;">
        <div class="max-w-7xl mx-auto px-4 py-6">
            <h1 class="text-3xl font-bold text-gray-900 mb-4">Live Currency Exchange Rates in Hawler, Iraq</h1>
            <p class="text-lg text-gray-600 mb-4">Get real-time exchange rates for USD, Euro, British Pound, Turkish Lira, Iranian Toman, UAE Dirham, Jordanian Dinar, Swedish Krona, Norwegian Krone, Swiss Franc, Saudi Riyal, Australian Dollar, and Canadian Dollar.</p>
            <div class="flex flex-wrap gap-4 text-sm text-gray-500">
                <span>📍 Location: Hawler (Erbil), Iraq</span>
                <span>📞 Phone: 0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173</span>
                <span>🌐 Website: www.al-aman.com</span>
                <span>⏰ Hours: Daily 9:00 AM - 6:00 PM</span>
            </div>
        </div>
    </header>
    
    @livewire('show-currency')


    <script>
             window.addEventListener('alert', event => {
                     toastr[event.detail.type](event.detail.message,
                     event.detail.title ?? ''), toastr.options = {
                            "closeButton": true,
                            "progressBar": true,
                        }
                    });
        </script>
        
        <!-- Live Timer and Date Script -->
        <script>
            // Function to initialize timer
            function initializeTimer() {
                function updateTimer() {
                    const timerElement = document.getElementById('live-timer');
                    const timerMobileElement = document.getElementById('live-timer-mobile');
                    const now = new Date();
                    let hours = now.getHours();
                    const minutes = String(now.getMinutes()).padStart(2, '0');
                    const seconds = String(now.getSeconds()).padStart(2, '0');
                    
                    // Convert to 12-hour format and add Kurdish AM/PM
                    const isAM = hours < 12;
                    const kurdishPeriod = isAM ? 'بەیانی' : 'ئێوارە';
                    
                    // Convert 24-hour to 12-hour format
                    if (hours === 0) {
                        hours = 12; // Midnight
                    } else if (hours > 12) {
                        hours = hours - 12; // PM hours
                    }
                    
                    const hours12 = String(hours).padStart(2, '0');
                    const timeString = hours12 + ':' + minutes + ':' + seconds + ' ' + kurdishPeriod;
                    
                    if (timerElement) {
                        timerElement.textContent = timeString;
                    }
                    if (timerMobileElement) {
                        timerMobileElement.textContent = timeString;
                    }
                    
                    // Debug logging
                    console.log('Timer update:', timeString);
                    console.log('Mobile timer element found:', !!timerMobileElement);
                }
                
                function updateDate() {
                    const dateElement = document.getElementById('live-date');
                    const dateMobileElement = document.getElementById('live-date-mobile');
                    const now = new Date();
                    const day = String(now.getDate()).padStart(2, '0');
                    const month = String(now.getMonth() + 1).padStart(2, '0');
                    const year = now.getFullYear();
                    const dateString = day + '/' + month + '/' + year;
                    
                    if (dateElement) {
                        dateElement.textContent = dateString;
                    }
                    if (dateMobileElement) {
                        dateMobileElement.textContent = dateString;
                    }
                }
                
                // Start timer and date immediately
                updateTimer();
                updateDate();
                
                // Also try to start timer after a short delay to ensure elements are loaded
                setTimeout(function() {
                    updateTimer();
                    updateDate();
                }, 100);
                
                // Additional fallback timer initialization
                setTimeout(function() {
                    updateTimer();
                    updateDate();
                }, 500);
                
                // Update timer every second
                setInterval(updateTimer, 1000);
                
                // Update date every minute (in case of date change)
                setInterval(updateDate, 60000);
            }

            // Try multiple ways to initialize the timer
            document.addEventListener('DOMContentLoaded', initializeTimer);
            window.addEventListener('load', initializeTimer);
            
            // Also try to initialize when Livewire is ready
            if (typeof Livewire !== 'undefined') {
                Livewire.on('DOMContentLoaded', initializeTimer);
            }
        </script>
    
    @livewireScripts
    
    <!-- SEO-Friendly Footer Section -->
    <footer class="bg-gray-800 text-white py-8" style="display: none;">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-xl font-bold mb-4">About al-aman</h3>
                    <p class="text-gray-300 mb-4">Professional currency exchange service in Hawler, Iraq offering competitive rates for major world currencies. We provide reliable, secure, and fast currency exchange services.</p>
                    <p class="text-gray-300">📍  هەڤاڵان كۆڵانى باب الحاره - جادەى بيستيەكەى</p>
                </div>
                <div>
                    <h3 class="text-xl font-bold mb-4">Our Services</h3>
                    <ul class="text-gray-300 space-y-2">
                        <li>• USD to Iraqi Dinar Exchange</li>
                        <li>• Euro to Iraqi Dinar Exchange</li>
                        <li>• British Pound Exchange</li>
                        <li>• Turkish Lira Exchange</li>
                        <li>• UAE Dirham Exchange</li>
                        <li>• Saudi Riyal Exchange</li>
                        <li>• Australian Dollar Exchange</li>
                        <li>• Canadian Dollar Exchange</li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-xl font-bold mb-4">Contact Information</h3>
                    <div class="text-gray-300 space-y-2">
                        <p>📞 Phone: 0751 825 3732 <br>
                    0751 466 8873, 
                    0751 531 4173</p>
                        <p>🌐 Website: www.al-aman.com</p>
                        <p>⏰ Hours: Daily 9:00 AM - 6:00 PM</p>
                        <p>📍 Location: Hawler (Erbil), Iraq</p>
                    </div>
                </div>
            </div>
            <div class="border-t border-gray-700 mt-8 pt-8 text-center text-gray-400">
                <p>&copy; 2024 al-aman. All rights reserved. | Professional Currency Exchange Services in Hawler, Iraq</p>
            </div>
        </div>
    </footer>
    
    <!-- Additional SEO JavaScript -->
    <script>
        // Add structured data for currency rates
        document.addEventListener('DOMContentLoaded', function() {
            // This will be populated by the Livewire component
            const currencyData = {
                "@context": "https://schema.org",
                "@type": "Dataset",
                "name": "Live Currency Exchange Rates",
                "description": "Real-time currency exchange rates for major world currencies in Hawler, Iraq",
                "keywords": "currency exchange, exchange rates, USD, Euro, Pound, Turkish Lira, UAE Dirham, Saudi Riyal, Australian Dollar, Canadian Dollar, Hawler, Erbil, Iraq, Kurdistan",
                "url": window.location.href,
                "spatialCoverage": {
                    "@type": "Place",
                    "name": "Hawler, Erbil, Iraq"
                },
                "temporalCoverage": "Real-time updates every 30 minutes"
            };
            
            // Add the structured data to the page
            const script = document.createElement('script');
            script.type = 'application/ld+json';
            script.textContent = JSON.stringify(currencyData);
            document.head.appendChild(script);
        });
    </script>

</body>
</html>






