@extends('layouts/layoutMaster')
@section('title', 'Currencies')

@section('content')
    <div class="searchbar mt-0 mb-4">
        <div class="row">
            <div class="col-md-6">
                <form>
                    <div class="input-group">
                        <input
                            required
                            id="indexSearch"
                            type="text"
                            name="search"
                            placeholder="{{ __('crud.common.search') }}"
                            value="{{ $search ?? '' }}"
                            class="form-control"
                            autocomplete="off"
                        />
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6 text-right">
                @can('create', App\Models\Currency::class)
                <a
                    href="{{ route('currencies.create') }}"
                    class="btn btn-primary"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div style="display: flex; justify-content: space-between;">
                <h4 class="card-title">@lang('crud.currencies.index_title')</h4>
            </div>
            @if(session()->get('message'))
                <div class="alert {{session()->get('message')['type']}} alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        {{session()->get('message')['message']}}
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <div class="table-responsive">
                <table class="table table-borderless table-hover" id="table_id">
                    <thead>
                        <tr>
                            <th class="text-left">
                                @lang('crud.currencies.inputs.currency_name')
                            </th>
                            <th class="text-left">
                                دابەشکردن لە کاتی کڕین
                            </th>
                            <th class="text-left">
                                @lang('crud.currencies.inputs.code')
                            </th>
                            <th class="text-left">
                                @lang('crud.currencies.inputs.type')
                            </th>
                            <th class="text-left">
                                @lang('crud.common.actions')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($currencies as $currency)
                        <tr>
                            <td>{{ $currency->currency_name ?? '-' }}</td>
                            <td>{{ $currency->use_division_for_buy == 1 ? 'بەڵێ' : 'نەخێر' }}</td>
                            <td>
                                <x-partials.thumbnail
                                    src="{{ $currency->code ? \Storage::url($currency->code) : '' }}"
                                />
                            </td>
                            <td>{{ isset($currency->type) ? ($currency->type == 0 ? trans('crud.currencies.inputs.physical') : trans('crud.currencies.inputs.digital')) : '-' }}</td>
                            <td class="text-center" style="width: 134px;">
                                <div
                                    role="group"
                                    aria-label="Row Actions"
                                    class="btn-group"
                                >
                                    @can('update', $currency)
                                    <a
                                        href="{{ route('currencies.edit', $currency) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-primary"
                                            title="Update"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-primary
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
                                    @endcan @can('view', $currency)
                                    <a
                                        href="{{ route('currencies.show', $currency) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-info"
                                            title="View"
                                            type="button"
                                            class="
                                                btn btn-icon btn-outline-info
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-eye"></i>
                                        </button>
                                    </a>
                                    @endcan @can('delete', $currency)
                                    <form
                                        action="{{ route('currencies.destroy', $currency) }}"
                                        method="POST"
                                        onsubmit="return confirm('{{ __('crud.common.are_you_sure') }}')"
                                    >
                                        @csrf @method('DELETE')
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-danger"
                                            title="Delete"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-danger
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4">
                                @lang('crud.common.no_items_found')
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="4">{!! $currencies->render() !!}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection
