@php $editing = isset($currency) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-3">
        <x-inputs.text
            name="currency_name"
            label="<?php echo trans('crud.currencies.inputs.currency_name'); ?>"
            :value="old('currency_name', ($editing ? $currency->currency_name : ''))"
            maxlength="255"
            placeholder="<?php echo trans('crud.currencies.inputs.currency_name'); ?>"
            required
        ></x-inputs.text>
    </x-inputs.group>

    {{-- <x-inputs.group class="col-sm-12 col-lg-3">
        <x-inputs.number
            name="rate"
            label="<?php echo trans('crud.currencies.inputs.rate'); ?>"
            :value="old('rate', ($editing ? $currency->rate : ''))"
            maxlength="255"
            placeholder="<?php echo trans('crud.currencies.inputs.rate'); ?>"
            required
        ></x-inputs.number>
    </x-inputs.group> --}}

    <x-inputs.group class="col-sm-12 col-lg-3 mt-4">
        <x-inputs.checkbox
            name="use_division_for_buy"
            label="دابەشکردن لە کاتی کڕین"
            :checked="old('use_division_for_buy', ($editing ? $currency->use_division_for_buy : false))"
        ></x-inputs.checkbox>
    </x-inputs.group>
    

    <x-inputs.group class="col-sm-12 col-lg-3">
        <x-inputs.select
            name="type"
            label="<?php echo trans('crud.currencies.inputs.type'); ?>"
            required
        >
            <option value="0" {{ old('type', $editing && $currency->type == 0 ? 'selected' : '') }}>
                <?php echo trans('crud.currencies.inputs.physical'); ?>
            </option>
            <option value="1" {{ old('type', $editing && $currency->type == 1 ? 'selected' : '') }}>
                <?php echo trans('crud.currencies.inputs.digital'); ?>
            </option>
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-3">
        <div
            x-data="imageViewer('{{ $editing && $currency->code ? \Storage::url($currency->code) : '' }}')"
        >
            <x-inputs.partials.label
                name="code"
                label="<?php echo trans('crud.currencies.inputs.code'); ?>"
            ></x-inputs.partials.label><br />

            <!-- Show the image -->
            <template x-if="imageUrl">
                <img
                    :src="imageUrl"
                    class="object-cover rounded border border-gray-200"
                    style="width: 100px; height: 100px;"
                />
            </template>

            <!-- Show the gray box when image is not available -->
            <template x-if="!imageUrl">
                <div
                    class="border rounded border-gray-200 bg-gray-100"
                    style="width: 100px; height: 100px;"
                ></div>
            </template>

            <div class="">
                <input
                    type="file"
                    name="code"
                    id="image"
                    class="form-control"
                    @change="fileChosen"
                />
            </div>

            @error('code') @include('components.inputs.partials.error') @enderror
        </div>
    </x-inputs.group>
</div>
