@extends('layouts/layoutMaster')

@section('title', 'Update currencies')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('currencies.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.currencies.edit_title')
            </h4>

            <x-form
            has-files
                method="PUT"
                action="{{ route('currencies.update', $currency) }}"
                class="mt-4"
            >
                @include('app.currencies.form-inputs')

                <div class="mt-4">
                    <a
                        href="{{ route('currencies.index') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-return-left text-primary"></i>
                        @lang('crud.common.back')
                    </a>

                    <a
                        href="{{ route('currencies.create') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-add text-primary"></i>
                        @lang('crud.common.create')
                    </a>

                    <button type="submit" class="btn btn-primary float-right">
                        <i class="icon ion-md-save"></i>
                        @lang('crud.common.update')
                    </button>
                </div>
            </x-form>
        </div>
    </div>
@endsection
