@extends('layouts/layoutMaster')

@section('title', 'Create currencies')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('currencies.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.currencies.create_title')
            </h4>

            <x-form
            has-files
                method="POST"
                action="{{ route('currencies.store') }}"
                class="mt-4"
            >
                @include('app.currencies.form-inputs')

                <div class="mt-4">
                    <a
                        href="{{ route('currencies.index') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-return-left text-primary"></i>
                        @lang('crud.common.back')
                    </a>

                    <button type="submit" class="btn btn-primary float-right">
                        <i class="icon ion-md-save"></i>
                        @lang('crud.common.create')
                    </button>
                </div>
            </x-form>
        </div>
    </div>
@endsection
