@extends('layouts/layoutMaster')
@section('title', 'Show Clinic')

@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('clinics.index') }}" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Clinic
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Name</h5>
                    <span>{{ $clinic->name ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Phone</h5>
                    <span>{{ $clinic->phone ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Email</h5>
                    <span>{{ $clinic->email ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Address</h5>
                    <span>{{ $clinic->address ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a href="{{ route('clinics.index') }}" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                @can('update', $clinic)
                <a href="{{ route('clinics.edit', $clinic) }}" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection

