@extends('layouts/layoutMaster')
@section('title', 'Clinics')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="card-title mb-0">Clinics</h4>
                @can('create', App\Models\Clinic::class)
                <a href="{{ route('clinics.create') }}" class="btn btn-primary">
                    <i class="icon ion-md-add"></i> Create Clinic
                </a>
                @endcan
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Address</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($clinics as $clinic)
                            <tr>
                                <td>{{ $clinic->name }}</td>
                                <td>{{ $clinic->phone ?? '-' }}</td>
                                <td>{{ $clinic->email ?? '-' }}</td>
                                <td>{{ $clinic->address ?? '-' }}</td>
                                <td>
                                    <div role="group" class="btn-group">
                                        @can('view', $clinic)
                                        <a href="{{ route('clinics.show', $clinic) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="icon ion-md-eye"></i>
                                        </a>
                                        @endcan
                                        @can('update', $clinic)
                                        <a href="{{ route('clinics.edit', $clinic) }}" class="btn btn-sm btn-outline-info">
                                            <i class="icon ion-md-create"></i>
                                        </a>
                                        @endcan
                                        @can('delete', $clinic)
                                        <form action="{{ route('clinics.destroy', $clinic) }}" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure?')">
                                                <i class="icon ion-md-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">No clinics found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $clinics->links() }}
            </div>
        </div>
    </div>
@endsection

