@extends('layouts/layoutMaster')
@section('title', 'Show Category')

@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('categories.index') }}" class="mr-4">
                    <i class="icon ion-md-arrow-back"></i>
                </a>
                Show Category
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>Name</h5>
                    <span>{{ $category->name ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Type</h5>
                    <span class="badge bg-{{ $category->type === 'service' ? 'primary' : ($category->type === 'drug' ? 'success' : 'info') }}">
                        {{ ucfirst($category->type) }}
                    </span>
                </div>
                <div class="mb-4">
                    <h5>Description</h5>
                    <span>{{ $category->description ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>Sort Order</h5>
                    <span>{{ $category->sort_order ?? '-' }}</span>
                </div>
            </div>

            @if($category->subcategories->count() > 0)
            <div class="mt-4">
                <h5>Subcategories</h5>
                <ul>
                    @foreach($category->subcategories as $subcategory)
                        <li>{{ $subcategory->name }} - Cost: {{ number_format($subcategory->cost, 2) }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <div class="mt-4">
                <a href="{{ route('categories.index') }}" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    Back
                </a>
                @can('update', $category)
                <a href="{{ route('categories.edit', $category) }}" class="btn btn-light">
                    <i class="icon ion-md-create"></i> Edit
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection

