@php $editing = isset($category) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="name"
            label="Category Name"
            :value="old('name', ($editing ? $category->name : ''))"
            maxlength="255"
            placeholder="Category Name"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.select name="type" label="Type" required>
            <option value="service" {{ old('type', ($editing ? $category->type : '')) == 'service' ? 'selected' : '' }}>Service</option>
            <option value="drug" {{ old('type', ($editing ? $category->type : '')) == 'drug' ? 'selected' : '' }}>Drug</option>
            <option value="other" {{ old('type', ($editing ? $category->type : '')) == 'other' ? 'selected' : '' }}>Other</option>
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="sort_order"
            label="Sort Order"
            :value="old('sort_order', ($editing ? $category->sort_order : '0'))"
            placeholder="Sort Order"
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.textarea name="description" label="Description"
            >{{ old('description', ($editing ? $category->description : '')) }}</x-inputs.textarea
        >
    </x-inputs.group>
</div>

