@extends('layouts/layoutMaster')

@section('title', 'Show cashiers')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('cashiers.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.cashiers.show_title')
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>@lang('crud.cashiers.inputs.cashier_name')</h5>
                    <span>{{ $cashier->cashier_name ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashiers.inputs.cashier_type')</h5>
                    <span>{{ $cashier->cashier_type ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashiers.inputs.start_time')</h5>
                    <span>{{ $cashier->start_time ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashiers.inputs.end_time')</h5>
                    <span>{{ $cashier->end_time ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a href="{{ route('cashiers.index') }}" class="btn btn-light">
                    <i class="icon ion-md-return-left"></i>
                    @lang('crud.common.back')
                </a>

                @can('create', App\Models\Cashier::class)
                <a href="{{ route('cashiers.create') }}" class="btn btn-light">
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection
