@php $editing = isset($cashier) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.text
            name="cashier_name"
            label="<?php echo trans('crud.cashiers.inputs.cashier_name'); ?>"
            :value="old('cashier_name', ($editing ? $cashier->cashier_name : ''))"
            maxlength="255"
            placeholder="<?php echo trans('crud.cashiers.inputs.cashier_name'); ?>"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.select name="cashier_type" label="<?php echo trans('crud.cashiers.inputs.cashier_type'); ?>">
            @php $selected = old('cashier_type', ($editing ? $cashier->cashier_type : '')) @endphp
            <option value="supervisor" {{ $selected == 'supervisor' ? 'selected' : '' }} >Supervisor</option>
            <option value="cashier" {{ $selected == 'cashier' ? 'selected' : '' }} >Cashier</option>
        </x-inputs.select>
    </x-inputs.group>

    {{-- <div class="col-6 ">
        <label for="transaction_time" class="form-label"><?php echo trans('crud.cashiers.inputs.start_time'); ?></label>
        <input type="time" required placeholder="Start Time" name="start_time" value="{{old('start_time', ($editing ? $cashier->start_time : ''))}}" class="form-control" id="transaction_time">
        @error('start_time') <span class="text-danger">{{ $message }}</span> @enderror
    </div>

    <div class="col-6 ">
        <label for="transaction_time" class="form-label"><?php echo trans('crud.cashiers.inputs.end_time'); ?></label>
        <input type="time" required placeholder="End Time" name="end_time" value="{{old('end_time', ($editing ? $cashier->end_time : ''))}}" class="form-control" id="end_time">
        @error('end_time') <span class="text-danger">{{ $message }}</span> @enderror
    </div> --}}
    
</div>
