@extends('layouts/layoutMaster')

@section('title', 'Show cashier_shifts')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('cashier-shifts.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.cashier_shifts.show_title')
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>@lang('crud.cashier_shifts.inputs.cashier_id')</h5>
                    <span
                        >{{ optional($cashierShift->cashier)->cashier_name ??
                        '-' }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashier_shifts.inputs.supervisor_id')</h5>
                    <span
                        >{{ optional($cashierShift->user)->name ?? '-' }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashier_shifts.inputs.start_time')</h5>
                    <span>{{ $cashierShift->start_time ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashier_shifts.inputs.end_time')</h5>
                    <span>{{ $cashierShift->end_time ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashier_shifts.inputs.starting_amount')</h5>
                    <span>{{ $cashierShift->starting_amount ?? '-' }}</span>
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.cashier_shifts.inputs.ending_amount')</h5>
                    <span>{{ $cashierShift->ending_amount ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a
                    href="{{ route('cashier-shifts.index') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-return-left"></i>
                    @lang('crud.common.back')
                </a>

                @can('create', App\Models\CashierShift::class)
                <a
                    href="{{ route('cashier-shifts.create') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection
