@extends('layouts/layoutMaster')
@section('title', 'Cashier Shifts')

@section('content')
    <div class="searchbar mt-0 mb-4">
        <div class="row">
            <div class="col-md-6">
                <form>
                    <div class="input-group">
                        <input
                            required
                            id="indexSearch"
                            type="text"
                            name="search"
                            placeholder="{{ __('crud.common.search') }}"
                            value="{{ $search ?? '' }}"
                            class="form-control"
                            autocomplete="off"
                        />
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6 text-right">
                @can('create', App\Models\CashierShift::class)
                <a
                    href="{{ route('cashier-shifts.create') }}"
                    class="btn btn-primary"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div style="display: flex; justify-content: space-between;">
                <h4 class="card-title">
                    @lang('crud.cashier_shifts.index_title')
                </h4>
            </div>
            @if(session()->get('message'))
                <div class="alert {{session()->get('message')['type']}} alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        {{session()->get('message')['message']}}
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <div class="table-responsive">
                <table class="table table-borderless table-hover" id="table_id">
                    <thead>
                        <tr>
                            <th class="text-left">
                                @lang('crud.cashier_shifts.inputs.cashier_id')
                            </th>
                            <th class="text-left">
                                @lang('crud.cashier_shifts.inputs.supervisor_id')
                            </th>
                            <th class="text-left">
                                @lang('crud.cashier_shifts.inputs.start_time')
                            </th>
                            <th class="text-left">
                                @lang('crud.cashier_shifts.inputs.end_time')
                            </th>
                            <th class="text-right">
                                @lang('crud.cashier_shifts.inputs.starting_amount')
                            </th>
                            <th class="text-right">
                                @lang('crud.cashier_shifts.inputs.ending_amount')
                            </th>
                            <th class="text-center">
                                @lang('crud.common.actions')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($cashierShifts as $cashierShift)
                        <tr>
                            <td>
                                {{
                                optional($cashierShift->cashier)->cashier_name
                                ?? '-' }}
                            </td>
                            <td>
                                {{ optional($cashierShift->user)->name ?? '-' }}
                            </td>
                            <td>{{ $cashierShift->start_time ?? '-' }}</td>
                            <td>{{ $cashierShift->end_time ?? '-' }}</td>
                            <td>{{ $cashierShift->starting_amount ?? '-' }}</td>
                            <td>{{ $cashierShift->ending_amount ?? '-' }}</td>
                            <td class="text-center" style="width: 134px;">
                                <div
                                    role="group"
                                    aria-label="Row Actions"
                                    class="btn-group"
                                >
                                    @can('update', $cashierShift)
                                    <a
                                        href="{{ route('cashier-shifts.edit', $cashierShift) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-primary"
                                            title="Update"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-primary
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
                                    @endcan @can('view', $cashierShift)
                                    <a
                                        href="{{ route('cashier-shifts.show', $cashierShift) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-info"
                                            title="View"
                                            type="button"
                                            class="
                                                btn btn-icon btn-outline-info
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-eye"></i>
                                        </button>
                                    </a>
                                    @endcan @can('delete', $cashierShift)
                                    <form
                                        action="{{ route('cashier-shifts.destroy', $cashierShift) }}"
                                        method="POST"
                                        onsubmit="return confirm('{{ __('crud.common.are_you_sure') }}')"
                                    >
                                        @csrf @method('DELETE')
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-danger"
                                            title="Delete"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-danger
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7">
                                @lang('crud.common.no_items_found')
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="7">
                                {!! $cashierShifts->render() !!}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection
