@php $editing = isset($cashierShift) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="cashier_id" label="Cashier" required>
            @php $selected = old('cashier_id', ($editing ? $cashierShift->cashier_id : '')) @endphp
            <option disabled {{ empty($selected) ? 'selected' : '' }}>Please select the Cashier</option>
            @foreach($cashiers as $value => $label)
            <option value="{{ $value }}" {{ $selected == $value ? 'selected' : '' }} >{{ $label }}</option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="supervisor_id" label="User" required>
            @php $selected = old('supervisor_id', ($editing ? $cashierShift->supervisor_id : '')) @endphp
            <option disabled {{ empty($selected) ? 'selected' : '' }}>Please select the User</option>
            @foreach($users as $value => $label)
            <option value="{{ $value }}" {{ $selected == $value ? 'selected' : '' }} >{{ $label }}</option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.text
            name="start_time"
            label="Start Time"
            :value="old('start_time', ($editing ? $cashierShift->start_time : ''))"
            maxlength="255"
            placeholder="Start Time"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.text
            name="end_time"
            label="End Time"
            :value="old('end_time', ($editing ? $cashierShift->end_time : ''))"
            maxlength="255"
            placeholder="End Time"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="starting_amount"
            label="Starting Amount"
            :value="old('starting_amount', ($editing ? $cashierShift->starting_amount : ''))"
            max="255"
            step="0.01"
            placeholder="Starting Amount"
            required
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12 col-lg-6">
        <x-inputs.number
            name="ending_amount"
            label="Ending Amount"
            :value="old('ending_amount', ($editing ? $cashierShift->ending_amount : ''))"
            max="255"
            step="0.01"
            placeholder="Ending Amount"
            required
        ></x-inputs.number>
    </x-inputs.group>
</div>
