<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Import Database Backup</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">Import Database Backup</h4>
                        <a href="{{ route('backup.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Backups
                        </a>
                    </div>

                    <div class="card-body">
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>Warning:</strong> Importing a backup will replace all existing data in your database. 
                            This action cannot be undone. Please make sure you have a current backup before proceeding.
                        </div>

                        <form action="{{ route('backup.import') }}" method="POST" enctype="multipart/form-data" id="importForm">
                            @csrf
                            
                            <div class="mb-4">
                                <label for="backup_file" class="form-label">
                                    <i class="fas fa-file-upload"></i> Select Backup File
                                </label>
                                <input type="file" 
                                       class="form-control @error('backup_file') is-invalid @enderror" 
                                       id="backup_file" 
                                       name="backup_file" 
                                       accept=".sql,.zip"
                                       required>
                                <div class="form-text">
                                    Accepted formats: .sql, .zip (max 50MB)
                                </div>
                                @error('backup_file')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="confirmImport" required>
                                    <label class="form-check-label text-danger" for="confirmImport">
                                        <strong>I understand that this will replace all existing data and cannot be undone</strong>
                                    </label>
                                </div>
                            </div>

                            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                <button type="button" class="btn btn-secondary me-md-2" onclick="window.history.back()">
                                    <i class="fas fa-times"></i> Cancel
                                </button>
                                <button type="submit" class="btn btn-danger" id="importBtn" disabled>
                                    <i class="fas fa-upload"></i> Import Backup
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Progress Modal -->
                <div class="modal fade" id="progressModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-body text-center">
                                <div class="spinner-border text-primary mb-3" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <h5>Importing Database...</h5>
                                <p class="text-muted">Please wait while your backup is being imported. This may take a few minutes.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const confirmCheckbox = document.getElementById('confirmImport');
        const importBtn = document.getElementById('importBtn');
        const importForm = document.getElementById('importForm');
        const fileInput = document.getElementById('backup_file');
        
        // Enable/disable import button based on checkbox
        confirmCheckbox.addEventListener('change', function() {
            importBtn.disabled = !this.checked;
        });
        
        // Show file size and validate on file selection
        fileInput.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                const fileSize = (file.size / 1024 / 1024).toFixed(2); // Size in MB
                
                if (file.size > 50 * 1024 * 1024) { // 50MB limit
                    alert('File size exceeds 50MB limit. Please choose a smaller file.');
                    this.value = '';
                    return;
                }
                
                // Update form text to show file info
                const formText = this.parentElement.querySelector('.form-text');
                formText.innerHTML = `Selected: ${file.name} (${fileSize} MB)<br>Accepted formats: .sql, .zip (max 50MB)`;
            }
        });
        
        // Show progress modal on form submission
        importForm.addEventListener('submit', function() {
            const progressModal = new bootstrap.Modal(document.getElementById('progressModal'));
            progressModal.show();
            
            // Disable the import button to prevent double submission
            importBtn.disabled = true;
            importBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Importing...';
        });
    });
    </script>
</body>
</html>