@extends('layouts/layoutMaster')
@section('title', 'Accounts')

@section('content')
    <div class="searchbar mt-0 mb-4">
        <div class="row">
            <div class="col-md-6">
                <form>
                    <div class="input-group">
                        <input
                            required
                            id="indexSearch"
                            type="text"
                            name="search"
                            placeholder="{{ __('crud.common.search') }}"
                            value="{{ $search ?? '' }}"
                            class="form-control"
                            autocomplete="off"
                        />
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div style="display: flex; justify-content: space-between;">
                <h4 class="card-title">@lang('crud.accounts.index_title')</h4>
            </div>
            @if(session()->get('message'))
                <div class="alert {{session()->get('message')['type']}} alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        {{session()->get('message')['message']}}
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <div class="table-responsive">
                <table class="table table-border table-hover">
                    <thead>
                        <tr>
                            <th class="text-left">
                                @lang('crud.accounts.inputs.account_number')
                            </th>
                            <th class="text-right">
                                @lang('crud.accounts.inputs.balance')
                            </th>
                            <th class="text-left">
                                @lang('crud.accounts.inputs.customer_id')
                            </th>
                            {{-- <th class="text-left">
                                @lang('crud.accounts.inputs.account_type')
                            </th> --}}
                            <th class="text-center">
                                @lang('crud.common.actions')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($accounts as $account)
                        <tr>
                            <td>{{ $account->account_title ?? '-' }} ({{ $account->currency->currency_name ?? '-' }})</td>
                            <td>{{  number_format($account->calculateTotalBalance(), 0, '.', ',') ?? '-' }} {{$account->currency->currency_name}}</td>
                            <td>
                                {{ optional($account->customer)->customer_name
                                ?? '-' }}
                            </td>
                            {{-- <td>{{ $account->account_type ?? '-' }}</td> --}}
                            <td class="text-center" style="width: 134px;">
                                <div
                                    role="group"
                                    aria-label="Row Actions"
                                    class="btn-group"
                                >
                                   
                                     @can('view', $account)
                                    <a
                                        href="{{ route('accounts.show', $account) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-info"
                                            title="View"
                                            type="button"
                                            class="
                                                btn btn-icon btn-outline-info
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-eye"></i>
                                        </button>
                                    </a>
                                    @endcan @can('delete', $account)
                                    <form
                                        action="{{ route('accounts.destroy', $account) }}"
                                        method="POST"
                                        onsubmit="return confirm('{{ __('crud.common.are_you_sure') }}')"
                                    >
                                        @csrf @method('DELETE')
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-danger"
                                            title="Delete"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-danger
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5">
                                @lang('crud.common.no_items_found')
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="5">{!! $accounts->render() !!}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection
