@php $editing = isset($account) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12">
        <x-inputs.text
            name="account_number"
            label="Account Number"
            :value="old('account_number', ($editing ? $account->account_number : ''))"
            maxlength="255"
            placeholder="Account Number"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.number
            name="balance"
            label="Balance"
            :value="old('balance', ($editing ? $account->balance : ''))"
            max="255"
            step="0.01"
            placeholder="Balance"
            required
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="customer_id" label="Customer" required>
            @php $selected = old('customer_id', ($editing ? $account->customer_id : '')) @endphp
            <option disabled {{ empty($selected) ? 'selected' : '' }}>Please select the Customer</option>
            @foreach($customers as $value => $label)
            <option value="{{ $value }}" {{ $selected == $value ? 'selected' : '' }} >{{ $label }}</option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="account_type" label="Account Type">
            @php $selected = old('account_type', ($editing ? $account->account_type : '')) @endphp
            <option value="savings" {{ $selected == 'savings' ? 'selected' : '' }} >Savings</option>
            <option value="checking" {{ $selected == 'checking' ? 'selected' : '' }} >Checking</option>
        </x-inputs.select>
    </x-inputs.group>
</div>
