@extends('layouts/layoutMaster')
@section('title', 'File Upload')

@section('content')
<div class="card">

    @if (session('success'))
        <div class="alert alert-primary alert-dismissible fade show" role="alert">
            {{ session('success') }}
        </div>
    @endif
    
  
    <div class="card-body">
        <form action="{{ route('file.upload', [$model, $id]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="file">{{ __('word.File') }}</label>
                <input type="file" name="file" class="form-control" id="file" accept="image/*"> <!-- Accept only images -->
            </div>
            <button type="submit" class="btn btn-primary mt-3">{{ __('word.Save') }}</button>
        </form>

        <!-- Display uploaded files -->
        <h3 class="mt-4">{{ __('word.Uploaded Files') }}</h3>
        @if ($files->isEmpty())
            <p>{{ __('word.No files uploaded yet.') }}</p>
        @else
            <ul class="list-group">
                @foreach ($files as $file)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank">{{ basename($file->file_path) }}</a>
                        <span class="text-muted"> (Uploaded on {{ $file->created_at->format('d-m-Y H:i') }})</span>
                        
                        <!-- Delete button -->
                        <form action="{{ route('files.destroy', $file->id) }}" method="POST" class="ml-2">
                            @csrf
                            @method('DELETE') <!-- This directive is used to spoof the DELETE method -->
                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('{{ __('word.Are you sure you want to delete this file?') }}');">{{ __('word.Delete') }}</button>
                        </form>
                    </li>
                @endforeach
            </ul>
        @endif
    </div>
</div>

@endsection
