@extends('layouts/layoutMaster')

@section('title', 'Update accounts')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('accounts.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.accounts.edit_title')
            </h4>

            <x-form
                method="PUT"
                action="{{ route('accounts.update', $account) }}"
                class="mt-4"
            >
                @include('app.accounts.form-inputs')

                <div class="mt-4">
                    <a
                        href="{{ route('accounts.index') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-return-left text-primary"></i>
                        @lang('crud.common.back')
                    </a>

                    <a
                        href="{{ route('accounts.create') }}"
                        class="btn btn-light"
                    >
                        <i class="icon ion-md-add text-primary"></i>
                        @lang('crud.common.create')
                    </a>

                    <button type="submit" class="btn btn-primary float-right">
                        <i class="icon ion-md-save"></i>
                        @lang('crud.common.update')
                    </button>
                </div>
            </x-form>
        </div>
    </div>

    @can('view-any', App\Models\AccountTransaction::class)
    <div class="card mt-4">
        <div class="card-body">
            <h4 class="card-title w-100 mb-2">Account Transactions</h4>

            <livewire:account-account-transactions-detail :account="$account" />
        </div>
    </div>
    @endcan
@endsection
