@extends('layouts/layoutMaster')

@section('title', 'Show account_transactions')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">
                <a href="{{ route('account-transactions.index') }}" class="mr-4"
                    ><i class="icon ion-md-arrow-back"></i
                ></a>
                @lang('crud.account_transactions.show_title')
            </h4>

            <div class="mt-4">
                <div class="mb-4">
                    <h5>
                        @lang('crud.account_transactions.inputs.account_id')
                    </h5>
                    <span
                        >{{
                        optional($accountTransaction->account)->account_title ??
                        '-' }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>
                        @lang('crud.account_transactions.inputs.transaction_type')
                    </h5>
                    <span
                        >{{ $accountTransaction->transaction_type ?? '-'
                        }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>
                        @lang('crud.account_transactions.inputs.transaction_amount')
                    </h5>
                    <span
                        >{{ $accountTransaction->transaction_amount ?? '-'
                        }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>
                        @lang('crud.account_transactions.inputs.transaction_date')
                    </h5>
                    <span
                        >{{ $accountTransaction->transaction_date ?? '-'
                        }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>
                        @lang('crud.account_transactions.inputs.transaction_time')
                    </h5>
                    <span
                        >{{ $accountTransaction->transaction_time ?? '-'
                        }}</span
                    >
                </div>
                <div class="mb-4">
                    <h5>@lang('crud.account_transactions.inputs.note')</h5>
                    <span>{{ $accountTransaction->note ?? '-' }}</span>
                </div>
            </div>

            <div class="mt-4">
                <a
                    href="{{ route('account-transactions.index') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-return-left"></i>
                    @lang('crud.common.back')
                </a>

                @can('create', App\Models\AccountTransaction::class)
                <a
                    href="{{ route('account-transactions.create') }}"
                    class="btn btn-light"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>
@endsection
