@extends('layouts/layoutMaster')
@section('title', 'Account Transaction')

@section('content')
    <div class="searchbar mt-0 mb-4">
        <div class="row">
            <div class="col-md-6">
                <form>
                    <div class="input-group">
                        <input
                            required
                            id="indexSearch"
                            type="text"
                            name="search"
                            placeholder="{{ __('crud.common.search') }}"
                            value="{{ $search ?? '' }}"
                            class="form-control"
                            autocomplete="off"
                        />
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6 text-right">
                @can('create', App\Models\AccountTransaction::class)
                <a
                    href="{{ route('account-transactions.create') }}"
                    class="btn btn-primary"
                >
                    <i class="icon ion-md-add"></i> @lang('crud.common.create')
                </a>
                @endcan
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div style="display: flex; justify-content: space-between;">
                <h4 class="card-title">
                    @lang('crud.account_transactions.index_title')
                </h4>
            </div>
            @if(session()->get('message'))
                <div class="alert {{session()->get('message')['type']}} alert-dismissible fade show" role="alert">
                    <div class="alert-body">
                        {{session()->get('message')['message']}}
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <div class="table-responsive">
                <table class="table table-borderless table-hover" id="table_id">
                    <thead>
                        <tr>
                            <th class="text-left">
                                @lang('crud.account_transactions.inputs.account_id')
                            </th>
                            <th class="text-left">
                                @lang('crud.account_transactions.inputs.transaction_type')
                            </th>
                            <th class="text-right">
                                @lang('crud.account_transactions.inputs.transaction_amount')
                            </th>
                            <th class="text-left">
                                @lang('crud.account_transactions.inputs.transaction_date')
                            </th>
                            <th class="text-left">
                                @lang('crud.account_transactions.inputs.transaction_time')
                            </th>
                            <th class="text-left">
                                @lang('crud.account_transactions.inputs.note')
                            </th>
                            <th class="text-center">
                                @lang('crud.common.actions')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($accountTransactions as $accountTransaction)
                        <tr>
                            <td>
                                {{
                                optional($accountTransaction->account)->account_title
                                ?? '-' }}
                            </td>
                            <td>
                                {{ $accountTransaction->transaction_type ?? '-'
                                }}
                            </td>
                            <td>
                                {{ $accountTransaction->transaction_amount ??
                                '-' }}
                            </td>
                            <td>
                                {{ $accountTransaction->transaction_date ?? '-'
                                }}
                            </td>
                            <td>
                                {{ $accountTransaction->transaction_time ?? '-'
                                }}
                            </td>
                            <td>{{ $accountTransaction->note ?? '-' }}</td>
                            <td class="text-center" style="width: 134px;">
                                <div
                                    role="group"
                                    aria-label="Row Actions"
                                    class="btn-group"
                                >
                                    @can('update', $accountTransaction)
                                    <a
                                        href="{{ route('account-transactions.edit', $accountTransaction) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-primary"
                                            title="Update"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-primary
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
                                    @endcan @can('view', $accountTransaction)
                                    <a
                                        href="{{ route('account-transactions.show', $accountTransaction) }}"
                                    >
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-info"
                                            title="View"
                                            type="button"
                                            class="
                                                btn btn-icon btn-outline-info
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-eye"></i>
                                        </button>
                                    </a>
                                    @endcan @can('delete', $accountTransaction)
                                    <form
                                        action="{{ route('account-transactions.destroy', $accountTransaction) }}"
                                        method="POST"
                                        onsubmit="return confirm('{{ __('crud.common.are_you_sure') }}')"
                                    >
                                        @csrf @method('DELETE')
                                        <button
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            data-bs-custom-class="tooltip-danger"
                                            title="Delete"
                                            type="submit"
                                            class="
                                                btn btn-icon btn-outline-danger
                                                m-1
                                            "
                                        >
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7">
                                @lang('crud.common.no_items_found')
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="7">
                                {!! $accountTransactions->render() !!}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection
