@php $editing = isset($accountTransaction) @endphp

<div class="row">
    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="account_id" label="Account" required>
            @php $selected = old('account_id', ($editing ? $accountTransaction->account_id : '')) @endphp
            <option disabled {{ empty($selected) ? 'selected' : '' }}>Please select the Account</option>
            @foreach($accounts as $value => $label)
            <option value="{{ $value }}" {{ $selected == $value ? 'selected' : '' }} >{{ $label }}</option>
            @endforeach
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.select name="transaction_type" label="Transaction Type">
            @php $selected = old('transaction_type', ($editing ? $accountTransaction->transaction_type : '')) @endphp
            <option value="deposit" {{ $selected == 'deposit' ? 'selected' : '' }} >Deposit</option>
            <option value="withdrawal" {{ $selected == 'withdrawal' ? 'selected' : '' }} >Withdrawal</option>
            <option value="transfer" {{ $selected == 'transfer' ? 'selected' : '' }} >Transfer</option>
        </x-inputs.select>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.number
            name="transaction_amount"
            label="Transaction Amount"
            :value="old('transaction_amount', ($editing ? $accountTransaction->transaction_amount : ''))"
            max="255"
            step="0.01"
            placeholder="Transaction Amount"
            required
        ></x-inputs.number>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.date
            name="transaction_date"
            label="Transaction Date"
            value="{{ old('transaction_date', ($editing ? optional($accountTransaction->transaction_date)->format('Y-m-d') : '')) }}"
            max="255"
            required
        ></x-inputs.date>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.text
            name="transaction_time"
            label="Transaction Time"
            :value="old('transaction_time', ($editing ? $accountTransaction->transaction_time : ''))"
            maxlength="255"
            placeholder="Transaction Time"
            required
        ></x-inputs.text>
    </x-inputs.group>

    <x-inputs.group class="col-sm-12">
        <x-inputs.textarea name="note" label="Note" maxlength="255" required
            >{{ old('note', ($editing ? $accountTransaction->note : ''))
            }}</x-inputs.textarea
        >
    </x-inputs.group>
</div>
