<?php

/**
 * Manual OneSignal API Test
 * 
 * This script tests OneSignal API authentication manually
 * Run: php manual_onesignal_test.php
 */

// Configuration - UPDATE THESE VALUES
$appId = '737941d8-27b3-49b6-82f7-fd46ab10fd74';
$restApiKey = 'YOUR_REST_API_KEY_HERE'; // Replace with your actual REST API Key

echo "🔍 Manual OneSignal API Test\n";
echo "============================\n\n";

if ($restApiKey === 'YOUR_REST_API_KEY_HERE') {
    echo "❌ Please update the REST API Key in this script first!\n";
    echo "   Get it from: https://app.onesignal.com/apps/{$appId}/settings/keys_and_ids\n";
    exit(1);
}

echo "App ID: {$appId}\n";
echo "REST API Key: " . substr($restApiKey, 0, 10) . "... (length: " . strlen($restApiKey) . ")\n\n";

// Test 1: Check App Info
echo "1. Testing App Info API:\n";
$url = "https://onesignal.com/api/v1/apps/{$appId}";
$headers = [
    'Authorization: Basic ' . $restApiKey,
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ cURL Error: {$error}\n";
} else {
    echo "   HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        echo "   ✅ Success! App Name: " . ($data['name'] ?? 'Unknown') . "\n";
    } else {
        echo "   ❌ Failed! Response: {$response}\n";
    }
}

echo "\n";

// Test 2: Send Test Notification
echo "2. Testing Notification Send:\n";
$url = "https://onesignal.com/api/v1/notifications";
$payload = [
    'app_id' => $appId,
    'include_player_ids' => ['test-player-id-' . time()],
    'contents' => ['en' => 'Manual test notification'],
    'data' => ['type' => 'manual_test']
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "   ❌ cURL Error: {$error}\n";
} else {
    echo "   HTTP Code: {$httpCode}\n";
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['errors'])) {
            echo "   ❌ OneSignal Errors:\n";
            foreach ($data['errors'] as $error) {
                echo "      - {$error}\n";
            }
        } else {
            echo "   ✅ Success! Notification ID: " . ($data['id'] ?? 'Unknown') . "\n";
        }
    } else {
        echo "   ❌ Failed! Response: {$response}\n";
    }
}

echo "\n";
echo "✅ Test completed!\n";
echo "\nIf you're still getting 403 errors:\n";
echo "1. Double-check your REST API Key from OneSignal dashboard\n";
echo "2. Make sure there are no extra spaces or characters\n";
echo "3. Verify you're using the REST API Key, not the App ID or User Auth Key\n";
echo "4. Check that the key is from the correct app\n";


