<?php

/**
 * OneSignal API Key Helper
 * 
 * This script helps you get the correct OneSignal API keys
 */

echo "🔑 OneSignal API Key Helper\n";
echo "===========================\n\n";

echo "To fix your 403 error, you need to get your REST API Key from OneSignal dashboard:\n\n";

echo "1. Go to: https://app.onesignal.com/apps/737941d8-27b3-49b6-82f7-fd46ab10fd74/settings/keys_and_ids\n";
echo "2. Look for 'REST API Key' section\n";
echo "3. Copy the REST API Key (it should be a long string like: YjA2NzQ4YjEtNzU4MS00YjQ5LWE5...)\n";
echo "4. Also copy the 'User Auth Key' if available\n\n";

echo "Then update your .env file with:\n";
echo "ONESIGNAL_REST_API_KEY=your_actual_rest_api_key_here\n";
echo "ONESIGNAL_USER_AUTH_KEY=your_actual_user_auth_key_here\n\n";

echo "After updating .env, run these commands:\n";
echo "php artisan config:clear\n";
echo "php artisan config:cache\n";
echo "php artisan onesignal:debug\n\n";

echo "Common mistakes:\n";
echo "- Using App ID instead of REST API Key\n";
echo "- Using User Auth Key instead of REST API Key\n";
echo "- Copying with extra spaces or quotes\n";
echo "- Using key from wrong app\n\n";

echo "The REST API Key should be around 40-60 characters long.\n";
echo "It's different from the App ID (which is: 737941d8-27b3-49b6-82f7-fd46ab10fd74)\n";


