-- Fix Kurdish Text Encoding in Database
-- Run this script with: mysql -u username -p database_name < fix_kurdish_sql.sql

-- Set the connection to use UTF-8
SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Show current corrupted data
SELECT id, transaction_type, note, person_name, created_at 
FROM account_transactions 
WHERE note LIKE '%?%' OR person_name LIKE '%?%'
ORDER BY id DESC
LIMIT 20;

-- Fix the specific transaction with known text
UPDATE account_transactions 
SET note = 'ئاسۆ کوی' 
WHERE id = 129518;

-- Verify the fix
SELECT id, note, person_name 
FROM account_transactions 
WHERE id = 129518;

-- Show remaining corrupted transactions
SELECT id, transaction_type, note, person_name, created_at 
FROM account_transactions 
WHERE (note LIKE '%?%' OR person_name LIKE '%?%') 
  AND id != 129518
ORDER BY id DESC
LIMIT 20;



