<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use App\Models\Notification;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Finding all notifications and checking for corruption...\n\n";
    
    // Get all notifications
    $notifications = Notification::orderBy('id', 'desc')->get();
    
    echo "Found {$notifications->count()} total notifications\n\n";
    
    $corruptedCount = 0;
    $correctCount = 0;
    
    foreach ($notifications as $notification) {
        echo "=== Notification ID: {$notification->id} ===\n";
        echo "Title: {$notification->title}\n";
        echo "Body: {$notification->body}\n";
        echo "Body length: " . strlen($notification->body) . "\n";
        
        // Check if body contains question marks
        if (strpos($notification->body, '?') !== false) {
            echo "⚠️ CORRUPTED - Contains question marks!\n";
            echo "Body bytes: " . implode(', ', array_map('ord', str_split($notification->body))) . "\n";
            $corruptedCount++;
        } else {
            echo "✅ CORRECT - No question marks\n";
            $correctCount++;
        }
        
        echo "Type: {$notification->type}\n";
        echo "User ID: {$notification->user_id}\n";
        echo "Created at: {$notification->created_at}\n";
        echo "\n";
    }
    
    echo "=== Summary ===\n";
    echo "Total notifications: {$notifications->count()}\n";
    echo "Corrupted notifications: $corruptedCount\n";
    echo "Correct notifications: $correctCount\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}







