#!/bin/bash

# Statistics Feature Deployment Script
# Run this on your PRODUCTION SERVER via SSH

echo "🚀 Deploying Statistics Feature to Production..."
echo "=================================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Step 1: Pull Latest Code
echo -e "${BLUE}📦 Step 1: Pulling latest code from GitHub...${NC}"
git pull origin main

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Code pulled successfully${NC}"
else
    echo -e "${RED}❌ Git pull failed${NC}"
    echo "Try: git stash && git pull origin main"
    exit 1
fi

echo ""

# Step 2: Run Migrations
echo -e "${BLUE}🗄️  Step 2: Running database migrations...${NC}"
php artisan migrate --force

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Migrations completed${NC}"
else
    echo -e "${RED}❌ Migration failed${NC}"
    exit 1
fi

echo ""

# Step 3: Seed App Versions
echo -e "${BLUE}📱 Step 3: Seeding app versions...${NC}"
php artisan db:seed --class=AppVersionSeeder --force

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ App versions seeded${NC}"
else
    echo -e "${YELLOW}⚠️  App version seeding had issues (might already exist)${NC}"
fi

echo ""

# Step 4: Seed Currency Rate History
echo -e "${BLUE}💱 Step 4: Seeding currency rate history (30 days)...${NC}"
php artisan db:seed --class=CurrencyRateHistorySeeder --force

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Rate history seeded${NC}"
else
    echo -e "${YELLOW}⚠️  Rate history seeding had issues${NC}"
fi

echo ""

# Step 5: Record Current Rates
echo -e "${BLUE}📊 Step 5: Recording current rates...${NC}"
php artisan currency:record-rates

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Current rates recorded${NC}"
else
    echo -e "${YELLOW}⚠️  Rate recording had issues${NC}"
fi

echo ""

# Step 6: Clear Caches
echo -e "${BLUE}🧹 Step 6: Clearing caches...${NC}"
php artisan optimize:clear
php artisan config:clear
php artisan route:clear

echo -e "${GREEN}✅ Caches cleared${NC}"

echo ""

# Step 7: Optimize for Production
echo -e "${BLUE}⚡ Step 7: Optimizing for production...${NC}"
php artisan config:cache
php artisan route:cache
php artisan view:cache

echo -e "${GREEN}✅ Optimization complete${NC}"

echo ""
echo "=================================================="
echo -e "${GREEN}🎉 Statistics Feature Deployed Successfully!${NC}"
echo ""
echo -e "${BLUE}📋 Verification:${NC}"
echo ""
echo "Test Statistics API:"
echo "curl https://LA DERMA.innovation-pulsehub.com/api/mobile/statistics/transactions \\"
echo "  -H 'Authorization: Bearer YOUR_TOKEN'"
echo ""
echo "Test App Version API:"
echo "curl https://LA DERMA.innovation-pulsehub.com/api/mobile/app-version \\"
echo "  -H 'X-Platform: ios' \\"
echo "  -H 'X-App-Version: 1.0.14'"
echo ""
echo -e "${GREEN}✅ Your Flutter app should now show statistics charts!${NC}"
echo ""
echo -e "${YELLOW}📱 Next: Restart your Flutter app (press R)${NC}"
echo ""

