<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\AccountTransaction;
use App\Helpers\KurdishTextHelper;
use Illuminate\Support\Facades\DB;

echo "\n";
echo "==========================================\n";
echo " Debugging Transaction 129518\n";
echo "==========================================\n\n";

// Get raw data from database
$raw = DB::select("SELECT id, note, person_name, HEX(note) as note_hex FROM account_transactions WHERE id = 129518");

if (!empty($raw)) {
    $r = $raw[0];
    echo "RAW DATABASE DATA:\n";
    echo "ID: {$r->id}\n";
    echo "Note (raw): '{$r->note}'\n";
    echo "Note (hex): {$r->note_hex}\n";
    echo "Length: " . strlen($r->note) . " bytes\n";
    echo "Encoding: " . mb_detect_encoding($r->note, ['UTF-8', 'ASCII', 'ISO-8859-6', 'Windows-1256'], true) . "\n\n";
}

// Get via Eloquent
$transaction = AccountTransaction::find(129518);

if ($transaction) {
    echo "ELOQUENT MODEL DATA:\n";
    echo "Note: '{$transaction->note}'\n";
    echo "Length: " . strlen($transaction->note) . " bytes\n\n";
    
    // Test helper
    if (class_exists('App\Helpers\KurdishTextHelper')) {
        echo "HELPER TEST:\n";
        $fixed = KurdishTextHelper::process($transaction->note);
        echo "After KurdishTextHelper::process(): '{$fixed}'\n";
        echo "Expected: 'ئاسۆ کوی'\n";
        echo "Match: " . ($fixed === 'ئاسۆ کوی' ? 'YES' : 'NO') . "\n\n";
    }
    
    // Test JSON encoding
    echo "JSON ENCODING TEST:\n";
    $data = ['note' => $transaction->note];
    $json = json_encode($data);
    echo "Before JSON_UNESCAPED_UNICODE: {$json}\n";
    
    $json_unescaped = json_encode($data, JSON_UNESCAPED_UNICODE);
    echo "With JSON_UNESCAPED_UNICODE: {$json_unescaped}\n\n";
    
    // Test with fixed text
    $dataFixed = ['note' => 'ئاسۆ کوی'];
    $jsonFixed = json_encode($dataFixed, JSON_UNESCAPED_UNICODE);
    echo "Expected JSON: {$jsonFixed}\n\n";
}

echo "==========================================\n";
echo " Checking Config\n";
echo "==========================================\n\n";

try {
    $mappings = config('kurdish_mappings.mappings');
    if ($mappings) {
        echo "Config mappings loaded:\n";
        foreach ($mappings as $k => $v) {
            echo "  '{$k}' => '{$v}'\n";
            echo "  Key hex: " . bin2hex($k) . "\n";
            echo "  Val hex: " . bin2hex($v) . "\n\n";
        }
    } else {
        echo "No mappings found in config!\n";
    }
} catch (\Exception $e) {
    echo "Config error: {$e->getMessage()}\n";
}

echo "\n";



