<?php

echo "🔍 Debugging OneSignal API Call with Subscribed Player\n";
echo "====================================================\n\n";

$appId = '737941d8-27b3-49b6-82f7-fd46ab10fd74';
$restApiKey = 'YOUR_NEW_REST_API_KEY'; // Replace with your actual new key
$playerId = '30a509fb-2bdb-4934-b74d-2d0a07072fd3';

echo "App ID: {$appId}\n";
echo "REST API Key: " . substr($restApiKey, 0, 10) . "...\n";
echo "Player ID: {$playerId}\n";
echo "Player Status: Subscribed (confirmed in OneSignal dashboard)\n\n";

if ($restApiKey === 'YOUR_NEW_REST_API_KEY') {
    echo "❌ Please replace 'YOUR_NEW_REST_API_KEY' with your actual REST API Key!\n";
    exit(1);
}

// Test 1: Check player details
echo "1. Checking player details...\n";
$url = "https://onesignal.com/api/v1/players/{$playerId}?app_id={$appId}";
$headers = [
    'Authorization: Basic ' . $restApiKey,
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "   HTTP Code: {$httpCode}\n";
if ($httpCode === 200) {
    $data = json_decode($response, true);
    echo "   ✅ Player found!\n";
    echo "   Device Type: " . ($data['device_type'] ?? 'Unknown') . "\n";
    echo "   Invalid Identifier: " . ($data['invalid_identifier'] ? 'Yes' : 'No') . "\n";
    echo "   Last Active: " . ($data['last_active'] ?? 'Unknown') . "\n";
    echo "   Session Count: " . ($data['session_count'] ?? 'Unknown') . "\n";
} else {
    echo "   ❌ Player not found! Response: {$response}\n";
}

echo "\n";

// Test 2: Try different notification methods
echo "2. Testing different notification methods...\n\n";

// Method 1: include_player_ids (current method)
echo "   Method 1: include_player_ids\n";
$payload1 = [
    'app_id' => $appId,
    'include_player_ids' => [$playerId],
    'contents' => ['en' => 'Test notification - include_player_ids method'],
    'data' => ['type' => 'test_method_1']
];

$result1 = sendNotification($payload1, $restApiKey);
echo "   Result: {$result1}\n\n";

// Method 2: include_external_user_ids (if you have external user ID)
echo "   Method 2: include_external_user_ids (using user ID 147)\n";
$payload2 = [
    'app_id' => $appId,
    'include_external_user_ids' => ['147'], // User ID from database
    'contents' => ['en' => 'Test notification - include_external_user_ids method'],
    'data' => ['type' => 'test_method_2']
];

$result2 = sendNotification($payload2, $restApiKey);
echo "   Result: {$result2}\n\n";

// Method 3: Send to all users (to test if API works at all)
echo "   Method 3: Send to all users (test if API works)\n";
$payload3 = [
    'app_id' => $appId,
    'included_segments' => ['All'],
    'contents' => ['en' => 'Test notification - all users method'],
    'data' => ['type' => 'test_method_3']
];

$result3 = sendNotification($payload3, $restApiKey);
echo "   Result: {$result3}\n\n";

echo "✅ Debug completed!\n";

function sendNotification($payload, $restApiKey) {
    $url = "https://onesignal.com/api/v1/notifications";
    $headers = [
        'Authorization: Basic ' . $restApiKey,
        'Content-Type: application/json'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['errors'])) {
            return "❌ Errors: " . implode(', ', $data['errors']);
        } else {
            return "✅ Success! ID: " . ($data['id'] ?? 'Unknown') . ", Recipients: " . ($data['recipients'] ?? 'Unknown');
        }
    } else {
        return "❌ HTTP {$httpCode}: {$response}";
    }
}


