<?php

// Bootstrap Laravel
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;
use App\Models\Account;
use App\Models\Customer;

echo "=== DEBUGGING ACCOUNTS ===\n\n";

try {
    // Get all accounts
    echo "1. All accounts in database:\n";
    $allAccounts = Account::all();
    foreach ($allAccounts as $account) {
        echo "   ID: {$account->id}, Customer ID: {$account->customer_id}, Currency: {$account->currency_id}\n";
    }

    echo "\n2. All customers:\n";
    $customers = Customer::all();
    foreach ($customers as $customer) {
        echo "   Customer ID: {$customer->id}, Email: {$customer->email}\n";
    }

    echo "\n3. Accounts with their relationships:\n";
    $accountsWithRelations = Account::with(['customer', 'currency'])->get();
    foreach ($accountsWithRelations as $account) {
        echo "   Account ID: {$account->id}\n";
        echo "     Customer: " . ($account->customer ? $account->customer->email : 'NULL') . "\n";
        echo "     Currency: " . ($account->currency ? $account->currency->currency_name : 'NULL') . "\n";
        echo "\n";
    }

    echo "\n4. Testing account lookup for customer ID 1:\n";
    $customerId = 1;
    $customerAccounts = Account::where('customer_id', $customerId)->get();
    echo "   Found " . $customerAccounts->count() . " accounts for customer $customerId\n";
    foreach ($customerAccounts as $account) {
        echo "     Account ID: {$account->id}, Currency: {$account->currency_id}\n";
    }

    echo "\n5. Testing specific account lookup (ID 1):\n";
    $account = Account::with('customer')->find(1);
    if ($account) {
        echo "   Account ID: {$account->id}\n";
        echo "   Customer ID: {$account->customer_id}\n";
        echo "   Customer Email: " . ($account->customer ? $account->customer->email : 'NULL') . "\n";
        echo "   Currency ID: {$account->currency_id}\n";
    } else {
        echo "   Account with ID 1 not found\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== DEBUG COMPLETE ===\n";


