<?php

namespace Database\Seeders;

use App\Models\Notification;
use App\Models\User;
use Illuminate\Database\Seeder;

class NotificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all users to create notifications for
        $users = User::all();

        foreach ($users as $user) {
            // Create some sample notifications for each user
            $notifications = [
                [
                    'type' => 'transaction',
                    'title' => 'Transaction Completed',
                    'body' => 'Your deposit of $500.00 has been successfully processed.',
                    'data' => [
                        'transaction_id' => '123',
                        'amount' => '500.00',
                        'currency' => 'USD',
                        'user_email' => $user->email,
                    ],
                    'action_url' => '/transactions/123',
                    'is_read' => false,
                ],
                [
                    'type' => 'app',
                    'title' => 'Account Balance Updated',
                    'body' => 'Your account balance has been updated. Check your latest statement.',
                    'data' => [
                        'balance' => '1500.00',
                        'user_email' => $user->email,
                    ],
                    'action_url' => '/accounts',
                    'is_read' => false,
                ],
                [
                    'type' => 'currency_rate',
                    'title' => 'Currency Rate Alert',
                    'body' => 'USD to EUR rate has changed significantly. Current rate: 0.85',
                    'data' => [
                        'rate' => '0.85',
                        'from_currency' => 'USD',
                        'to_currency' => 'EUR',
                        'user_email' => $user->email,
                    ],
                    'action_url' => '/currency-rates',
                    'is_read' => true,
                ],
                [
                    'type' => 'app',
                    'title' => 'Welcome to LA DERMA',
                    'body' => 'Thank you for joining LA DERMA! Your account is now active and ready to use.',
                    'data' => [
                        'welcome' => true,
                        'user_email' => $user->email,
                    ],
                    'action_url' => '/welcome',
                    'is_read' => true,
                ],
                [
                    'type' => 'security',
                    'title' => 'Security Alert',
                    'body' => 'New login detected from a different device. If this wasn\'t you, please secure your account.',
                    'data' => [
                        'security_alert' => true,
                        'device' => 'Unknown Device',
                        'location' => 'Unknown Location',
                        'user_email' => $user->email,
                    ],
                    'action_url' => '/security',
                    'is_read' => true,
                ],
            ];

            foreach ($notifications as $index => $notificationData) {
                Notification::create(array_merge($notificationData, [
                    'user_id' => $user->id,
                    'created_at' => now()->subDays($index + 1),
                    'updated_at' => now()->subDays($index + 1),
                ]));
            }
        }
    }
}







