<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Adding an admin user
        $user = \App\Models\User::factory()
            ->count(1)
            ->create([
                'email' => 'admin@admin.com',
                'password' => \Hash::make('admin'),
            ]);
        $this->call(PermissionsSeeder::class);

        // Old financial system seeders - commented out since tables are removed
        // $this->call(AccountSeeder::class);
        // $this->call(AccountTransactionSeeder::class);
        // $this->call(CashierSeeder::class);
        // $this->call(CashierShiftSeeder::class);
        // $this->call(CurrencySeeder::class);
        // $this->call(CustomerSeeder::class);
        // $this->call(TransactionSeeder::class);
        
        $this->call(UserSeeder::class);
    }
}
