<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Drop foreign key constraints on clinic_id from patients table
        try {
            $constraints = DB::select("SELECT CONSTRAINT_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE TABLE_NAME = 'patients' AND COLUMN_NAME = 'clinic_id' AND TABLE_SCHEMA = DATABASE()");
            if (!empty($constraints)) {
                foreach ($constraints as $constraint) {
                    DB::statement("ALTER TABLE patients DROP FOREIGN KEY `{$constraint->CONSTRAINT_NAME}`");
                }
            }
        } catch (\Exception $e) {
            // Constraint might not exist
        }

        // Drop foreign key constraints on clinic_id from invoices table
        try {
            $constraints = DB::select("SELECT CONSTRAINT_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE TABLE_NAME = 'invoices' AND COLUMN_NAME = 'clinic_id' AND TABLE_SCHEMA = DATABASE()");
            if (!empty($constraints)) {
                foreach ($constraints as $constraint) {
                    DB::statement("ALTER TABLE invoices DROP FOREIGN KEY `{$constraint->CONSTRAINT_NAME}`");
                }
            }
        } catch (\Exception $e) {
            // Constraint might not exist
        }

        // Drop clinic_id column from patients table if it exists
        if (Schema::hasColumn('patients', 'clinic_id')) {
            Schema::table('patients', function (Blueprint $table) {
                $table->dropColumn('clinic_id');
            });
        }

        // Drop clinic_id column from invoices table if it exists
        if (Schema::hasColumn('invoices', 'clinic_id')) {
            Schema::table('invoices', function (Blueprint $table) {
                $table->dropColumn('clinic_id');
            });
        }

        // Drop clinics table if it exists
        Schema::dropIfExists('clinics');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Recreate clinics table
        Schema::create('clinics', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->text('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->timestamps();
        });

        // Re-add clinic_id to patients table
        if (!Schema::hasColumn('patients', 'clinic_id')) {
            Schema::table('patients', function (Blueprint $table) {
                $table->unsignedBigInteger('clinic_id')->nullable()->after('address');
                $table->foreign('clinic_id')->references('id')->on('clinics')->onDelete('set null');
                $table->index(['clinic_id', 'code']);
            });
        }

        // Re-add clinic_id to invoices table
        if (!Schema::hasColumn('invoices', 'clinic_id')) {
            Schema::table('invoices', function (Blueprint $table) {
                $table->unsignedBigInteger('clinic_id')->nullable()->after('patient_id');
                $table->foreign('clinic_id')->references('id')->on('clinics')->onDelete('set null');
                $table->index('clinic_id');
            });
        }
    }
};
